/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

class VertexData {
    private float[] coords;
    private byte[] colors;
    private float[] textureCoords;
    private int index;
    private int texIndex;
    boolean textured;

    VertexData(int n, boolean bl) {
        this.coords = new float[n * n * 2 * 3 * 3];
        if (bl) {
            this.textureCoords = new float[n * n * 2 * 3 * 2];
        } else {
            this.colors = new byte[this.coords.length];
        }
        this.textured = bl;
    }

    float[] getCoords() {
        return this.coords;
    }

    byte[] getColors() {
        return this.colors;
    }

    float[] getTextureCoords() {
        return this.textureCoords;
    }

    void addVertex(float f, float f2, float f3) {
        this.coords[this.index] = f;
        this.coords[this.index + 1] = f2;
        this.coords[this.index + 2] = f3;
        this.index += 3;
    }

    void addVertex(float f, float f2, float f3, byte by, byte by2, byte by3) {
        this.coords[this.index] = f;
        this.coords[this.index + 1] = f2;
        this.coords[this.index + 2] = f3;
        if (this.textured) {
            System.out.println("Setting color on a textured object");
        } else {
            this.colors[this.index] = by;
            this.colors[this.index + 1] = by2;
            this.colors[this.index + 2] = by3;
        }
        this.index += 3;
    }

    void addVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        byte by = (byte)(f4 * 255.0f);
        byte by2 = (byte)(f5 * 255.0f);
        byte by3 = (byte)(f6 * 255.0f);
        this.addVertex(f, f2, f3, by, by2, by3);
    }

    void addVertex(float f, float f2, float f3, float f4, float f5) {
        this.coords[this.index] = f;
        this.coords[this.index + 1] = f2;
        this.coords[this.index + 2] = f3;
        if (!this.textured) {
            System.out.println("Setting texture coords in coloured object");
        } else {
            this.textureCoords[this.texIndex++] = f4;
            this.textureCoords[this.texIndex++] = f5;
        }
        this.index += 3;
    }

    int getVertexCount() {
        return this.index / 3;
    }

    void reset() {
        this.index = 0;
        this.texIndex = 0;
    }
}

