/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import javax.vecmath.Point3f;
import org.j3d.util.interpolator.Interpolator;

public class PositionInterpolator
extends Interpolator {
    private Point3f sharedPoint;
    private float[] sharedVector;
    private float[][] keyValues;

    public PositionInterpolator() {
        this(20, 1);
    }

    public PositionInterpolator(int n) {
        this(n, 1);
    }

    public PositionInterpolator(int n, int n2) {
        super(n, n2);
        this.keys = new float[n];
        this.keyValues = new float[n][3];
        this.sharedPoint = new Point3f();
        this.sharedVector = new float[3];
    }

    public void addKeyFrame(float f, float f2, float f3, float f4) {
        float[] fArray;
        int n = this.findKeyIndex(f);
        this.realloc();
        if (n < 0) {
            n = 0;
        }
        if (n >= this.currentSize) {
            fArray = this.keyValues[this.currentSize];
        } else {
            if (this.keys[n] != f) {
                ++n;
            }
            int n2 = this.currentSize - n;
            System.arraycopy(this.keyValues, n, this.keyValues, n + 1, n2);
            System.arraycopy(this.keys, n, this.keys, n + 1, n2);
            fArray = new float[3];
            this.keyValues[n] = fArray;
        }
        fArray[0] = f2;
        fArray[1] = f3;
        fArray[2] = f4;
        this.keys[n] = f;
        ++this.currentSize;
    }

    public void addKeyFrame(float f, Point3f point3f) {
        this.addKeyFrame(f, point3f.x, point3f.y, point3f.z);
    }

    public Point3f pointValue(float f) {
        int n = this.findKeyIndex(f);
        if (n < 0) {
            this.sharedPoint.set(this.keyValues[0]);
        } else if (n >= this.currentSize - 1) {
            this.sharedPoint.set(this.keyValues[this.currentSize - 1]);
        } else {
            switch (this.interpolationType) {
                case 1: {
                    float[] fArray = this.keyValues[n + 1];
                    float[] fArray2 = this.keyValues[n];
                    float f2 = fArray[0] - fArray2[0];
                    float f3 = fArray[1] - fArray2[1];
                    float f4 = fArray[2] - fArray2[2];
                    float f5 = 0.0f;
                    float f6 = this.keys[n];
                    float f7 = this.keys[n + 1];
                    if (f7 != f6) {
                        f5 = (f - f6) / (f7 - f6);
                    }
                    this.sharedPoint.x = fArray2[0] + f5 * f2;
                    this.sharedPoint.y = fArray2[1] + f5 * f3;
                    this.sharedPoint.z = fArray2[2] + f5 * f4;
                    break;
                }
                case 2: {
                    float[] fArray = this.keyValues[n];
                    this.sharedPoint.x = fArray[0];
                    this.sharedPoint.y = fArray[1];
                    this.sharedPoint.z = fArray[2];
                }
            }
        }
        return this.sharedPoint;
    }

    public float[] floatValue(float f) {
        int n = this.findKeyIndex(f);
        if (n < 0) {
            this.sharedVector[0] = this.keyValues[0][0];
            this.sharedVector[1] = this.keyValues[0][1];
            this.sharedVector[2] = this.keyValues[0][2];
        } else if (n >= this.currentSize - 1) {
            this.sharedVector[0] = this.keyValues[this.currentSize - 1][0];
            this.sharedVector[1] = this.keyValues[this.currentSize - 1][1];
            this.sharedVector[2] = this.keyValues[this.currentSize - 1][2];
        } else {
            switch (this.interpolationType) {
                case 1: {
                    float[] fArray = this.keyValues[n + 1];
                    float[] fArray2 = this.keyValues[n];
                    float f2 = fArray[0] - fArray2[0];
                    float f3 = fArray[1] - fArray2[1];
                    float f4 = fArray[2] - fArray2[2];
                    float f5 = 0.0f;
                    float f6 = this.keys[n];
                    float f7 = this.keys[n + 1];
                    if (f7 != f6) {
                        f5 = (f - f6) / (f7 - f6);
                    }
                    this.sharedVector[0] = fArray2[0] + f5 * f2;
                    this.sharedVector[1] = fArray2[1] + f5 * f3;
                    this.sharedVector[2] = fArray2[2] + f5 * f4;
                    break;
                }
                case 2: {
                    float[] fArray = this.keyValues[n];
                    this.sharedVector[0] = fArray[0];
                    this.sharedVector[1] = fArray[1];
                    this.sharedVector[2] = fArray[2];
                }
            }
        }
        return this.sharedVector;
    }

    private final void realloc() {
        if (this.currentSize == this.allocatedSize) {
            int n = this.allocatedSize + 5;
            float[][] fArrayArray = new float[n][];
            System.arraycopy(this.keyValues, 0, fArrayArray, 0, this.allocatedSize);
            int n2 = this.allocatedSize;
            while (n2 < n) {
                fArrayArray[n2] = new float[3];
                ++n2;
            }
            float[] fArray = new float[n];
            System.arraycopy(this.keys, 0, fArray, 0, this.allocatedSize);
            this.keys = fArray;
            this.keyValues = fArrayArray;
            this.allocatedSize = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<position interpolator>\n");
        int n = 0;
        while (n < this.currentSize) {
            stringBuffer.append(n);
            stringBuffer.append(" key: ");
            stringBuffer.append(this.keys[n]);
            stringBuffer.append(" x: ");
            stringBuffer.append(this.keyValues[n][0]);
            stringBuffer.append(" y: ");
            stringBuffer.append(this.keyValues[n][1]);
            stringBuffer.append(" z: ");
            stringBuffer.append(this.keyValues[n][2]);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("</position interpolator>");
        return stringBuffer.toString();
    }
}

