/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.j3d.device.input.FileInputSensor;
import org.j3d.util.SAXEntityResolver;
import org.j3d.util.SAXErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileInputDevice
implements InputDevice {
    private static final String FILE_PROP = "org.j3d.device.input.file.data_file";
    private static final String DEFAULT_FILE_NAME = "input_data.xml";
    private static final String DATA_ELEMENT = "data";
    private static final String SENSOR_BUTTON_ELEMENT = "button";
    private static final String SENSOR_INFO_ELEMENT = "sensor-info";
    private static final String SENSOR_ELEMENT = "sensor";
    private static final String SENSOR_DATA_ELEMENT = "sensor-data";
    private static final String BUTTON_DATA_ELEMENT = "button-data";
    private static final String NUM_SENSOR_ATTR = "number";
    private static final String INDEX_ATTR = "index";
    private static final String TIME_ATTR = "time";
    private static final String POSITION_ATTR = "position";
    private static final String SENSOR_LOOP_ATTR = "loops";
    private static final String BUTTON_CNT_ATTR = "buttons";
    private static final String BUTTON_VALUE_ATTR = "value";
    private FileInputSensor[] sensorList;
    private int sensorCount;
    private int mode = 5;
    private Transform3D position_tx = new Transform3D();
    private Vector3f translation = new Vector3f();

    public boolean initialize() {
        URL uRL = this.findInputFile();
        if (uRL == null) {
            return false;
        }
        Document document = this.parseInputFile(uRL);
        if (document == null) {
            return false;
        }
        return this.parseDocument(document);
    }

    public int getSensorCount() {
        return this.sensorCount;
    }

    public Sensor getSensor(int n) {
        return this.sensorList[n];
    }

    public int getProcessingMode() {
        return this.mode;
    }

    public void setProcessingMode(int n) {
        this.mode = n;
    }

    public void setNominalPositionAndOrientation() {
        Transform3D transform3D = new Transform3D();
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        int n = 0;
        while (n < this.sensorList.length) {
            FileInputSensor fileInputSensor = this.sensorList[n];
            fileInputSensor.getRead(transform3D);
            transform3D.get(vector3d);
            point3d.set((Tuple3d)vector3d);
            fileInputSensor.setHotspot(point3d);
            ++n;
        }
    }

    public void processStreamInput() {
    }

    public void pollAndProcessInput() {
        long l = System.currentTimeMillis();
        float f = 0.0f;
        int n = 0;
        while (n < this.sensorList.length) {
            this.sensorList[n].recalculate(l, f);
            ++n;
        }
    }

    public void close() {
    }

    private URL findInputFile() {
        URL uRL = null;
        String string = System.getProperty(FILE_PROP, DEFAULT_FILE_NAME);
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(string);
        }
        try {
            File file = new File(string);
            if (file.exists()) {
                uRL = file.toURL();
            }
        }
        catch (SecurityException securityException) {
            System.err.println("Security exception reading local input file");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private Document parseInputFile(URL uRL) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = null;
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new SAXEntityResolver());
            documentBuilder.setErrorHandler(new SAXErrorHandler());
            document = documentBuilder.parse(uRL.openStream());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            System.err.println("Error configuring the factory. " + factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Error configuring the parser. " + parserConfigurationException);
        }
        catch (IOException iOException) {
            System.err.println("Error reading data stream " + iOException);
        }
        catch (SAXException sAXException) {
            System.err.println("Error parsing device information " + sAXException);
        }
        return document;
    }

    private boolean parseDocument(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(SENSOR_INFO_ELEMENT);
        if (nodeList.getLength() == 0) {
            return false;
        }
        Element element2 = (Element)nodeList.item(0);
        String string = element2.getAttribute(NUM_SENSOR_ATTR);
        this.sensorCount = Integer.parseInt(string);
        this.sensorList = new FileInputSensor[this.sensorCount];
        nodeList = element2.getElementsByTagName(SENSOR_ELEMENT);
        int n = nodeList.getLength();
        if (n < this.sensorCount) {
            System.err.println("Not enough sensor declarations for the number defined in sensors_data");
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            this.parseSensorData((Element)nodeList.item(n2));
            ++n2;
        }
        return true;
    }

    private void parseSensorData(Element element) {
        float f;
        Element element2;
        FileInputSensor fileInputSensor;
        String string = element.getAttribute(INDEX_ATTR);
        int n = Integer.parseInt(string);
        string = element.getAttribute(BUTTON_CNT_ATTR);
        int n2 = Integer.parseInt(string);
        string = element.getAttribute(TIME_ATTR);
        int n3 = Integer.parseInt(string);
        string = element.getAttribute(SENSOR_LOOP_ATTR);
        int n4 = Integer.parseInt(string);
        this.sensorList[n] = fileInputSensor = new FileInputSensor(this, n2);
        NodeList nodeList = element.getElementsByTagName(SENSOR_DATA_ELEMENT);
        int n5 = nodeList.getLength();
        int n6 = 0;
        while (n6 < n5) {
            element2 = (Element)nodeList.item(n6);
            string = element2.getAttribute(POSITION_ATTR);
            n = string.indexOf(32);
            String string2 = string.substring(0, n);
            try {
                float f2 = Float.parseFloat(string2);
                int n7 = n;
                n = string.indexOf(32, n);
                string2 = string.substring(n7 + 1, n);
                float f3 = Float.parseFloat(string2);
                string2 = string.substring(n + 1);
                float f4 = Float.parseFloat(string2);
                f = Float.parseFloat(element2.getAttribute(TIME_ATTR));
                fileInputSensor.addPositionData(f2, f3, f4, f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n6;
        }
        nodeList = element.getElementsByTagName(SENSOR_BUTTON_ELEMENT);
        n5 = nodeList.getLength();
        n6 = 0;
        while (n6 < n5) {
            element2 = (Element)nodeList.item(n6);
            string = element2.getAttribute(INDEX_ATTR);
            int n8 = Integer.parseInt(string);
            NodeList nodeList2 = element2.getElementsByTagName(BUTTON_DATA_ELEMENT);
            int n9 = nodeList2.getLength();
            int n10 = 0;
            while (n10 < n9) {
                try {
                    element2 = (Element)nodeList2.item(n10);
                    f = Float.parseFloat(element2.getAttribute(TIME_ATTR));
                    string = element2.getAttribute(BUTTON_VALUE_ATTR);
                    int n11 = Integer.parseInt(string);
                    fileInputSensor.addButtonData(n8, f, n11);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++n10;
            }
            ++n6;
        }
    }
}

