/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input;

import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3f;
import org.j3d.util.interpolator.PositionInterpolator;
import org.j3d.util.interpolator.ScalarInterpolator;

class FileInputSensor
extends Sensor {
    private static final int NUM_SENSOR_READS = 5;
    private static final int[] EMPTY_BUTTONS = new int[0];
    private PositionInterpolator positions = new PositionInterpolator();
    private ScalarInterpolator[] buttons;
    private Transform3D transform = new Transform3D();
    private Vector3f vector = new Vector3f();

    FileInputSensor(InputDevice inputDevice) {
        super(inputDevice);
    }

    FileInputSensor(InputDevice inputDevice, int n) {
        super(inputDevice, 5, n);
        this.buttons = new ScalarInterpolator[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            this.buttons[n2] = new ScalarInterpolator(5, 2);
            --n2;
        }
    }

    void addPositionData(float f, float f2, float f3, float f4) {
        this.positions.addKeyFrame(f, f2, f3, f4);
    }

    void addButtonData(int n, float f, int n2) {
        if (this.buttons == null) {
            throw new IllegalArgumentException("No buttons are defined!");
        }
        if (n < 0 || n >= this.buttons.length) {
            throw new IllegalArgumentException("Button index out of range");
        }
        this.buttons[n].addKeyFrame(f, n2);
    }

    void recalculate(long l, float f) {
        float[] fArray = this.positions.floatValue(f);
        this.vector.set(fArray);
        this.transform.set(this.vector);
        int[] nArray = EMPTY_BUTTONS;
        if (this.buttons != null) {
            nArray = new int[this.buttons.length];
            int n = this.buttons.length - 1;
            while (n >= 0) {
                nArray[n] = (int)this.buttons[n].floatValue(f);
                --n;
            }
        }
        this.setNextSensorRead(l, this.transform, nArray);
    }
}

