/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;
import org.j3d.device.input.spaceball.InputDeviceCallback;
import org.j3d.device.input.spaceball.transformation.DefaultManipulator;
import org.j3d.device.input.spaceball.transformation.Manipulator;

public class InputDeviceBehavior
extends Behavior {
    private final Sensor itsSensor;
    private TransformGroup itsTransformGroup = null;
    private Node itsLocalCoordinateSystemNode = null;
    private Manipulator itsManipulator = null;
    private final WakeupCondition itsWakeup;
    private final int[] itsButtonValues;
    private final Transform3D itsDeltaTransform = new Transform3D();
    private final Transform3D itsLocalToVWorldTransform = new Transform3D();
    private final Transform3D itsCurrentTransform = new Transform3D();
    private final Transform3D itsNewTransform = new Transform3D();
    private final Transform3D itsInitialTransform = new Transform3D();
    private InputDeviceCallback itsListener = null;

    public InputDeviceBehavior(Sensor sensor) {
        this(sensor, new DefaultManipulator());
    }

    public InputDeviceBehavior(Sensor sensor, Manipulator manipulator) {
        this.setSchedulingBounds((Bounds)new BoundingSphere());
        this.itsSensor = sensor;
        int n = sensor.getDevice().getProcessingMode();
        this.itsWakeup = n == 5 ? new WakeupOnBehaviorPost((Behavior)this, n) : new WakeupOnElapsedFrames(0);
        this.setManipulator(manipulator);
        this.itsButtonValues = new int[sensor.getSensorButtonCount()];
    }

    public void initialize() {
        this.wakeupOn(this.itsWakeup);
    }

    public synchronized void setManipulator(Manipulator manipulator) {
        if (manipulator != null) {
            this.itsManipulator = manipulator;
        }
    }

    public synchronized void setTransformGroup(TransformGroup transformGroup) {
        if (transformGroup.getCapability(17) && transformGroup.getCapability(18)) {
            this.itsTransformGroup = transformGroup;
            transformGroup.getTransform(this.itsInitialTransform);
        } else {
            this.itsTransformGroup = null;
        }
    }

    public synchronized void setLocalCoordinateSystemNode(Node node) {
        this.itsLocalCoordinateSystemNode = node;
        if (node == null) {
            this.itsLocalToVWorldTransform.setIdentity();
        }
    }

    public synchronized void setCallback(InputDeviceCallback inputDeviceCallback) {
        this.itsListener = inputDeviceCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration enumeration) {
        InputDeviceCallback inputDeviceCallback;
        Manipulator manipulator;
        Node node;
        TransformGroup transformGroup;
        InputDeviceBehavior inputDeviceBehavior = this;
        synchronized (inputDeviceBehavior) {
            transformGroup = this.itsTransformGroup;
            node = this.itsLocalCoordinateSystemNode;
            manipulator = this.itsManipulator;
            inputDeviceCallback = this.itsListener;
        }
        this.itsSensor.getRead(this.itsDeltaTransform);
        this.itsSensor.lastButtons(this.itsButtonValues);
        if (transformGroup != null) {
            if (node != null) {
                node.getLocalToVworld(this.itsLocalToVWorldTransform);
            }
            transformGroup.getTransform(this.itsCurrentTransform);
            manipulator.calculateTransform(this.itsNewTransform, this.itsCurrentTransform, this.itsDeltaTransform, this.itsLocalToVWorldTransform);
        }
        if (inputDeviceCallback != null) {
            inputDeviceCallback.update(this, transformGroup, this.itsNewTransform, this.itsDeltaTransform, this.itsButtonValues);
        } else if (transformGroup != null) {
            transformGroup.setTransform(this.itsNewTransform);
        }
        this.wakeupOn(this.itsWakeup);
    }

    public void reset() {
    }
}

