/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import org.j3d.device.input.spaceball.OnDemandInputDevice;

public class MouseInputDevice
extends OnDemandInputDevice
implements MouseListener,
MouseMotionListener {
    private final int[] itsCurrentValues = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] itsStartValues = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] itsDeltaValues = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] itsButtonValues = new int[]{0, 0, 0};
    private final int[] itsTempButtonValues = new int[]{0, 0, 0};

    public MouseInputDevice() {
        this.setScale(0, 0.005);
        this.setScale(1, 0.005);
    }

    public void attachToComponent(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void removeFromComponent(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            this.setMouseStartValues(mouseEvent.getX(), mouseEvent.getY());
            this.setMouseValues(mouseEvent.getX(), mouseEvent.getY());
            this.setButtonValue(0, 1);
        }
        if (mouseEvent.getModifiers() == 8) {
            this.setButtonValue(1, 1);
        }
        if (mouseEvent.getModifiers() == 4) {
            this.setButtonValue(2, 1);
        }
        this.postStimulus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            this.setButtonValue(0, 0);
        }
        if (mouseEvent.getModifiers() == 8) {
            this.setButtonValue(1, 0);
        }
        if (mouseEvent.getModifiers() == 4) {
            this.setButtonValue(2, 0);
        }
        this.postStimulus();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            this.setMouseValues(mouseEvent.getX(), mouseEvent.getY());
        }
        this.postStimulus();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public boolean initialize() {
        this.setSensor(new Sensor((InputDevice)this, 30, 3));
        this.setMouseStartValues(0, 0);
        this.setMouseValues(0, 0);
        return super.initialize();
    }

    public void pollAndProcessInput() {
        this.getDeltaValues(this.itsDeltaValues);
        this.getButtonValues(this.itsTempButtonValues);
        this.setDeltaDeviceInput(this.itsDeltaValues, this.itsTempButtonValues);
    }

    private synchronized void getDeltaValues(int[] nArray) {
        nArray[0] = this.itsCurrentValues[0] - this.itsStartValues[0];
        nArray[1] = this.itsStartValues[1] - this.itsCurrentValues[1];
        nArray[2] = this.itsCurrentValues[2] - this.itsStartValues[2];
        nArray[3] = this.itsCurrentValues[3] - this.itsStartValues[3];
        nArray[4] = this.itsCurrentValues[4] - this.itsStartValues[4];
        nArray[5] = this.itsCurrentValues[5] - this.itsStartValues[5];
        System.arraycopy(this.itsCurrentValues, 0, this.itsStartValues, 0, 6);
    }

    protected synchronized void setStartValue(int n, int n2) {
        this.itsStartValues[n] = n2;
    }

    private synchronized void setMouseStartValues(int n, int n2) {
        this.itsStartValues[0] = n;
        this.itsStartValues[1] = n2;
    }

    private synchronized void setMouseValues(int n, int n2) {
        this.itsCurrentValues[0] = n;
        this.itsCurrentValues[1] = n2;
    }

    protected synchronized void setInputValue(int n, int n2) {
        this.itsCurrentValues[n] = n2;
    }

    protected synchronized void setButtonValue(int n, int n2) {
        this.itsButtonValues[n] = n2;
    }

    protected synchronized void getButtonValues(int[] nArray) {
        System.arraycopy(this.itsButtonValues, 0, nArray, 0, 3);
    }
}

