/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.SerialPort;
import org.j3d.device.input.spaceball.driver.Spaceball3003CallbackInterface;
import org.j3d.device.input.spaceball.driver.Spaceball3003Packet;
import org.j3d.device.input.spaceball.driver.SpaceballDriver;
import org.j3d.device.input.spaceball.driver.SpaceballPacket;

public class Spaceball3003Driver
extends SpaceballDriver
implements Spaceball3003CallbackInterface {
    private static final int NUM_OF_BUTTONS = 8;

    public Spaceball3003Driver(SerialPort serialPort, InputStream inputStream, OutputStream outputStream) {
        super(serialPort, inputStream, outputStream, 13);
        this.setNumOfButtons(8);
    }

    protected void dispatch(byte[] byArray, int n, int n2, int n3) {
        if (n3 == 68) {
            if (n2 == 15) {
                Spaceball3003Packet.decodeBallData(byArray, this.itsPositionData, n);
            }
        } else if (n3 == 75) {
            if (n2 == 3) {
                Spaceball3003Packet.decodeButtonEvent(this.itsButtonData, byArray, n);
            }
        } else {
            Spaceball3003Packet.doCallBacks(byArray, this, n + 1, n2 - 1, n3);
        }
    }

    public void enableDevice(int n) throws IOException {
        int n2 = Spaceball3003Packet.createEnableDevicePacket(this.itsWriteBuffer, 0);
        this.write(this.itsWriteBuffer, 0, n2);
    }

    public void disableDevice(int n) throws IOException {
        int n2 = Spaceball3003Packet.createSimpleRequestPacket(this.itsWriteBuffer, 0, (byte)77);
        this.write(this.itsWriteBuffer, 0, n2);
    }

    public void rezeroDevice(int n) throws IOException {
        int n2 = SpaceballPacket.createSimpleRequestPacket(this.itsWriteBuffer, 0, (byte)90);
        this.write(this.itsWriteBuffer, 0, n2);
        this.waitForResponse(n, 90, "rezero device");
    }
}

