/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball.driver;

import org.j3d.device.input.spaceball.driver.Spaceball3003CallbackInterface;
import org.j3d.device.input.spaceball.driver.SpaceballPacket;

public class Spaceball3003Packet
extends SpaceballPacket {
    public static final int HARDWARE_ERROR_CODE_1 = 64;
    public static final int CALIBRATION_CHECKSUM_ERROR_CODE = 65;
    public static final int HARDWARE_ERROR_CODE_2 = 66;
    public static final int HARDWARE_ERROR_CODE_3 = 67;
    public static final int TRANSMIT_TIMEOUT_ERROR_CODE = 68;
    public static final int RECEIVE_OVERFLOW_ERROR_ERROR_CODE = 69;
    public static final int RECEIVE_ERROR_CODE = 70;
    public static final int BEEPER_QUEUE_OVERFLOW_ERROR_CODE = 71;
    public static final int PACKET_TOO_LONG_ERROR_CODE = 72;
    public static final int ENABLE_BALL_DATA = 5067603;
    public static final byte DISABLE_BALL_DATA = 77;
    public static final byte GET_REZERO_BALL = 90;
    private static final int[] ERROR_CODES = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72};
    private static final String[] ERROR_CODE_STRINGS = new String[]{"Hardware error", "Calibration checksum error", "Hardware error", "Hardware error", "Transmit timeout", "Receive overflow (host did ot stop for XOFF)", "Receive error", "Beeper queue overflow", "Packet too long"};

    public static int createEnableDevicePacket(byte[] byArray, int n) {
        byArray[n] = 83;
        byArray[n + 1] = 0;
        byArray[n + 2] = 0;
        byArray[n + 3] = 13;
        return 4;
    }

    public static void decodeButtonEvent(int[] nArray, byte[] byArray, int n) {
        int n2 = Spaceball3003Packet.makeWord(byArray[n + 1], byArray[n + 2]);
        SpaceballPacket.decodeButtonData(n2, nArray, SpaceballPacket.BUTTON_MASK);
    }

    public static void doCallBacks(byte[] byArray, Spaceball3003CallbackInterface spaceball3003CallbackInterface, int n, int n2, int n3) {
        switch (n3) {
            case 90: {
                spaceball3003CallbackInterface.processRequestResponse(n3);
                break;
            }
            case 64: {
                String string = new String(byArray, n, n2);
                int n4 = Integer.parseInt(string.substring(0, 1));
                spaceball3003CallbackInterface.processDeviceInfoResponse(n3, n4, string);
                break;
            }
            case 37: {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                spaceball3003CallbackInterface.processEchoResponse(byArray2);
                break;
            }
            case 69: {
                Spaceball3003Packet.decodeErrorPacket(spaceball3003CallbackInterface, new String(byArray, n, n2));
                break;
            }
            default: {
                spaceball3003CallbackInterface.processError(70, "Spaceball(TM) 2003/3003 device sent unknown packet.");
            }
        }
    }

    private static void decodeErrorPacket(Spaceball3003CallbackInterface spaceball3003CallbackInterface, String string) {
        int n = ERROR_CODES.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.indexOf(ERROR_CODES[n2]) > 0) {
                spaceball3003CallbackInterface.processError(ERROR_CODES[n2], "Spaceball(TM) 2003/3003: " + ERROR_CODE_STRINGS[n2]);
            }
            ++n2;
        }
    }
}

