/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball.driver;

public class SpaceballPacket {
    public static final int POSITION_DATA_PACKET_LENGTH = 15;
    public static final int BUTTON_DATA_PACKET_LENGTH = 3;
    public static final byte BALL_DATA = 68;
    public static final byte BUTTON_DATA = 75;
    public static final byte PATTERNED_BEEP = 66;
    public static final byte ERROR = 69;
    public static final byte ECHO = 37;
    public static final byte RESET_DEVICE = 64;
    public static final int[] BUTTON_MASK = new int[]{1, 2, 4, 8, 256, 512, 1024, 4096, 0, 0, 0, 0};
    public static final byte PACKET_TERMINATOR = 13;

    public static int createPatternedBeepPacket(byte[] byArray, int n, char[] cArray) {
        byArray[n] = 66;
        int n2 = cArray.length <= 16 ? cArray.length : 16;
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3 + 1] = (byte)cArray[n3];
            ++n3;
        }
        byArray[n + n2 + 1] = 13;
        return n2 + 2;
    }

    public static int createSimpleRequestPacket(byte[] byArray, int n, byte by) {
        byArray[n] = by;
        byArray[n + 1] = 13;
        return 2;
    }

    public static int createEchoPacket(byte[] byArray, int n, byte[] byArray2) {
        byArray[n] = 37;
        int n2 = byArray2 == null ? 0 : byArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3 + 1] = byArray2[n3];
            ++n3;
        }
        byArray[n + n2 + 1] = 13;
        return 2 + n2;
    }

    public static void decodeBallData(byte[] byArray, int[] nArray, int n) {
        nArray[0] = SpaceballPacket.makeWord(byArray[++n], byArray[++n]);
        nArray[1] = SpaceballPacket.makeWord(byArray[++n], byArray[++n]);
        nArray[2] = SpaceballPacket.makeWord(byArray[++n], byArray[++n]);
        nArray[3] = -SpaceballPacket.makeWord(byArray[++n], byArray[++n]);
        nArray[4] = -SpaceballPacket.makeWord(byArray[++n], byArray[++n]);
        nArray[5] = SpaceballPacket.makeWord(byArray[++n], byArray[++n]);
        nArray[6] = -SpaceballPacket.makeWord(byArray[++n], byArray[++n]);
    }

    protected static void decodeButtonData(int n, int[] nArray, int[] nArray2) {
        int n2 = nArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            if ((n & nArray2[n3]) > 0) {
                nArray[n3] = 1;
            }
            ++n3;
        }
    }

    protected static int makeWord(byte by, byte by2) {
        short s = (short)(by << 8);
        s = (short)(s | (short)(by2 & 0xFF));
        return s;
    }
}

