/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball.driver;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import org.j3d.device.input.spaceball.driver.Spaceball3003Driver;
import org.j3d.device.input.spaceball.driver.Spaceball4000Driver;
import org.j3d.device.input.spaceball.driver.SpaceballDriver;
import org.j3d.device.input.spaceball.driver.SpaceballPacket;

public class SpaceballTypeDetector {
    private static final int TYPECHECK_BUFFER_SIZE_IN_BYTE = 150;

    /*
     * Loose catch block
     */
    public static SpaceballDriver createSpaceballDriver(String string, int n) throws NoSuchPortException, PortInUseException, IOException, UnsupportedCommOperationException {
        SpaceballDriver spaceballDriver;
        InitWindow initWindow;
        block12: {
            initWindow = new InitWindow(string);
            SerialPort serialPort = null;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            spaceballDriver = null;
            serialPort = SpaceballDriver.openPort(string);
            inputStream = serialPort.getInputStream();
            outputStream = serialPort.getOutputStream();
            SpaceballDriver.pause(2000);
            spaceballDriver = SpaceballTypeDetector.detectType(string, serialPort, inputStream, outputStream);
            Object var10_7 = null;
            boolean bl = spaceballDriver != null;
            initWindow.finished(bl);
            try {
                Thread.sleep(2000L);
                break block12;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            {
                break block12;
                catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                    if (serialPort != null) {
                        serialPort.close();
                    }
                    throw unsupportedCommOperationException;
                }
                catch (IOException iOException) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (serialPort != null) {
                        serialPort.close();
                    }
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                boolean bl2 = spaceballDriver != null;
                initWindow.finished(bl2);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                initWindow.setVisible(false);
                initWindow.dispose();
                throw throwable;
            }
        }
        initWindow.setVisible(false);
        initWindow.dispose();
        return spaceballDriver;
    }

    private static SpaceballDriver detectType(String string, SerialPort serialPort, InputStream inputStream, OutputStream outputStream) throws IOException {
        SpaceballDriver spaceballDriver;
        byte[] byArray = new byte[2];
        SpaceballPacket.createSimpleRequestPacket(byArray, 0, (byte)34);
        outputStream.write(byArray);
        SpaceballDriver.pause(500);
        byte[] byArray2 = new byte[150];
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        while (n < 150 && l < l2) {
            if (inputStream.available() > 0) {
                n += inputStream.read(byArray2, n, 150 - n);
            }
            l = System.currentTimeMillis();
        }
        String string2 = new String(byArray2, 0, 150);
        while (inputStream.available() > 0) {
            inputStream.read(byArray2);
        }
        if (string2.indexOf("Spaceball") != -1) {
            spaceballDriver = string2.indexOf("4000 FLX") != -1 ? new Spaceball4000Driver(serialPort, inputStream, outputStream) : new Spaceball3003Driver(serialPort, inputStream, outputStream);
        } else {
            throw new IOException("Cannot detect supported Spaceball device on port " + string + ".");
        }
        return spaceballDriver;
    }

    private static class InitWindow
    extends Window {
        private static final char[] itsChar1 = new char[36];
        private static final char[] itsChar2 = new char[37];
        private static final String itsText4 = new String("OKFAILED");
        private final char[] itsChar3;
        private int itsLength = 0;

        public InitWindow(String string) {
            super(new Frame());
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(280, 70);
            this.setLocation((dimension.width - 280) / 2, (dimension.height - 70) / 2);
            this.setBackground(new Color(187, 187, 187));
            String string2 = new String("Driver for Labtec's Spaceball device");
            String string3 = new String("Copyright (c) 2001 by Paul Szawlowski");
            String string4 = new String("initializing " + string + "... ");
            this.itsLength = 17 + string.length();
            this.itsChar3 = new char[6 + this.itsLength];
            string2.getChars(0, 36, itsChar1, 0);
            string3.getChars(0, 37, itsChar2, 0);
            string4.getChars(0, this.itsLength, this.itsChar3, 0);
            this.setVisible(true);
        }

        public void finished(boolean bl) {
            int n = bl ? 0 : 2;
            int n2 = bl ? 2 : 6;
            itsText4.getChars(n, n2 + n, this.itsChar3, this.itsLength);
            this.itsLength += n2;
            this.repaint();
            this.toFront();
        }

        public void paint(Graphics graphics) {
            graphics.drawRect(2, 2, 275, 65);
            graphics.drawChars(itsChar1, 0, 36, 20, 20);
            graphics.drawChars(itsChar2, 0, 37, 20, 40);
            graphics.drawChars(this.itsChar3, 0, this.itsLength, 20, 60);
        }
    }
}

