/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball.transformation;

import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class TransformationUtils {
    public static final Point3d itsOrigin = new Point3d();
    public static final Vector3d itsInitialUpVector = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d itsInitialViewDirection = new Vector3d(0.0, 0.0, -1.0);

    public static void polarToCartesian(Tuple3d tuple3d, double d, double d2) {
        double d3 = Math.sin(d2);
        tuple3d.set(d3 * Math.cos(d), d3 * Math.sin(d), Math.cos(d2));
    }

    public static void polarToCartesian(Tuple3d tuple3d, double d, double d2, double d3) {
        double d4 = d * Math.sin(d3);
        tuple3d.set(d4 * Math.cos(d2), d4 * Math.sin(d2), d * Math.cos(d3));
    }

    public static void cartesianToPolar(double[] dArray, Tuple3d tuple3d) {
        double d;
        double d2 = tuple3d.x;
        double d3 = tuple3d.y;
        double d4 = tuple3d.z;
        double d5 = d2 * d2 + d3 * d3;
        double d6 = Math.sqrt(d5);
        dArray[0] = d = Math.sqrt(d5 + d4 * d4);
        dArray[3] = d6 / d;
        dArray[4] = d4 / d;
        dArray[1] = d3 / d6;
        dArray[2] = d2 / d6;
    }

    public static void getRotationTranslationTransform3D(double[] dArray, Transform3D transform3D, Vector3d vector3d, Point3d point3d, Vector3d vector3d2) {
        double d = Math.sin(dArray[3]);
        double d2 = Math.sin(dArray[4]);
        double d3 = Math.sin(dArray[5]);
        double d4 = Math.cos(dArray[3]);
        double d5 = Math.cos(dArray[4]);
        double d6 = Math.cos(dArray[5]);
        vector3d.set(dArray[0], dArray[1], dArray[2]);
        point3d.set(d2 * d4, d, -d5 * d4);
        vector3d2.set(-d2 * d * d6 + d4 * d3, -d2 * d * d3 + d4 * d6, d5 * d);
        transform3D.lookAt(itsOrigin, point3d, vector3d2);
        transform3D.setTranslation(vector3d);
    }

    public static void getRotationTransform3D(Transform3D transform3D, Point3d point3d, Vector3d vector3d, double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.sin(d2);
        double d6 = Math.sin(d3);
        double d7 = Math.cos(d);
        double d8 = Math.cos(d2);
        double d9 = Math.cos(d3);
        point3d.set(d5 * d7, d4, -d8 * d7);
        vector3d.set(-d5 * d4 * d9 + d7 * d6, -d5 * d4 * d6 + d7 * d9, d8 * d4);
        transform3D.lookAt(itsOrigin, point3d, vector3d);
    }

    public static void getScaleTransform3D(Transform3D transform3D, Matrix3d matrix3d, double d, double d2, double d3) {
        matrix3d.m00 = d;
        matrix3d.m11 = d2;
        matrix3d.m22 = d3;
        transform3D.setRotationScale(matrix3d);
    }

    public static void getXRotationTransform3D(Transform3D transform3D, Matrix3d matrix3d, double d, double d2) {
        matrix3d.m11 = d2;
        matrix3d.m21 = -d;
        matrix3d.m12 = d;
        matrix3d.m22 = d2;
        transform3D.setRotationScale(matrix3d);
    }

    public static void getYRotationTransform3D(Transform3D transform3D, Matrix3d matrix3d, double d, double d2) {
        matrix3d.m00 = d2;
        matrix3d.m20 = -d;
        matrix3d.m02 = d;
        matrix3d.m22 = d2;
        transform3D.setRotationScale(matrix3d);
    }

    public static void getZRotationTransform3D(Transform3D transform3D, Matrix3d matrix3d, double d, double d2) {
        matrix3d.m00 = d2;
        matrix3d.m10 = -d;
        matrix3d.m01 = d;
        matrix3d.m11 = d2;
        transform3D.setRotationScale(matrix3d);
    }
}

