/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import org.j3d.geom.BoxGenerator;
import org.j3d.geom.GeometryData;

public class Axis
extends Group {
    private static final float DEFAULT_AXIS_LENGTH = 5.0f;
    private static final float X_SIZE = 0.05f;

    public Axis() {
        this(5.0f);
    }

    public Axis(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Axis length is not positive");
        }
        int n = 3;
        BoxGenerator boxGenerator = new BoxGenerator(0.05f, 0.05f, f);
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 3;
        geometryData.geometryComponents = 2;
        boxGenerator.generate(geometryData);
        TriangleStripArray triangleStripArray = new TriangleStripArray(geometryData.vertexCount, n, geometryData.stripCounts);
        triangleStripArray.setCoordinates(0, geometryData.coordinates);
        triangleStripArray.setNormals(0, geometryData.normals);
        boxGenerator.setDimensions(0.05f, f, 0.05f);
        boxGenerator.generate(geometryData);
        TriangleStripArray triangleStripArray2 = new TriangleStripArray(geometryData.vertexCount, n, geometryData.stripCounts);
        triangleStripArray2.setCoordinates(0, geometryData.coordinates);
        triangleStripArray2.setNormals(0, geometryData.normals);
        boxGenerator.setDimensions(f, 0.05f, 0.05f);
        boxGenerator.generate(geometryData);
        TriangleStripArray triangleStripArray3 = new TriangleStripArray(geometryData.vertexCount, n, geometryData.stripCounts);
        triangleStripArray3.setCoordinates(0, geometryData.coordinates);
        triangleStripArray3.setNormals(0, geometryData.normals);
        Color3f color3f = new Color3f(0.0f, 0.0f, 0.8f);
        Material material = new Material();
        material.setDiffuseColor(color3f);
        material.setLightingEnable(true);
        Color3f color3f2 = new Color3f(0.8f, 0.0f, 0.0f);
        Material material2 = new Material();
        material2.setDiffuseColor(color3f2);
        material2.setLightingEnable(true);
        Color3f color3f3 = new Color3f(0.0f, 0.8f, 0.0f);
        Material material3 = new Material();
        material3.setDiffuseColor(color3f3);
        material3.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material2);
        Appearance appearance2 = new Appearance();
        appearance2.setMaterial(material3);
        Appearance appearance3 = new Appearance();
        appearance3.setMaterial(material);
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.addGeometry((Geometry)triangleStripArray);
        Shape3D shape3D2 = new Shape3D();
        shape3D2.setAppearance(appearance2);
        shape3D2.addGeometry((Geometry)triangleStripArray2);
        Shape3D shape3D3 = new Shape3D();
        shape3D3.setAppearance(appearance3);
        shape3D3.addGeometry((Geometry)triangleStripArray3);
        this.addChild((Node)shape3D);
        this.addChild((Node)shape3D2);
        this.addChild((Node)shape3D3);
    }
}

