/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import org.j3d.geom.BoxGenerator;
import org.j3d.geom.GeometryData;

public class Box
extends Shape3D {
    private static final float DEFAULT_SIZE = 2.0f;
    private BoxGenerator generator;
    private GeometryData data = new GeometryData();

    public Box() {
        this(2.0f, 2.0f, 2.0f, null);
    }

    public Box(Appearance appearance) {
        this(2.0f, 2.0f, 2.0f, appearance);
    }

    public Box(float f, float f2, float f3) {
        this(f, f2, f3, null);
    }

    public Box(float f, float f2, float f3, Appearance appearance) {
        this.data.geometryType = 3;
        this.data.geometryComponents = 2;
        this.generator = new BoxGenerator(f, f2, f3);
        this.generator.generate(this.data);
        int n = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setCapability(13);
        this.setAppearance(appearance);
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setDimensions(float f, float f2, float f3) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setDimensions(f, f2, f3);
        this.generator.generate(this.data);
        int n = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }
}

