/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class BoxGenerator
extends GeometryGenerator {
    private static final int BASIC_VERTEX_COUNT = 24;
    private static final int TRIANGLE_VERTEX_COUNT = 36;
    private float boxWidth;
    private float boxHeight;
    private float boxDepth;

    public BoxGenerator() {
        this(2.0f, 2.0f, 2.0f);
    }

    public BoxGenerator(float f, float f2, float f3) {
        this.boxWidth = f;
        this.boxHeight = f2;
        this.boxDepth = f3;
    }

    public float[] getDimensions() {
        return new float[]{this.boxWidth, this.boxHeight, this.boxDepth};
    }

    public void setDimensions(float f, float f2, float f3) {
        this.boxWidth = f;
        this.boxHeight = f2;
        this.boxDepth = f3;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                n = 36;
                break;
            }
            case 2: {
                n = 24;
                break;
            }
            case 3: {
                n = 24;
                break;
            }
            case 4: {
                n = 24;
                break;
            }
            case 5: {
                n = 24;
                break;
            }
            case 6: {
                n = 24;
                break;
            }
            case 7: {
                n = 24;
                break;
            }
            case 8: {
                n = 24;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 2: {
                this.unindexedQuads(geometryData);
                break;
            }
            case 3: {
                this.triangleStrips(geometryData);
                break;
            }
            case 4: {
                this.triangleFans(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            case 8: {
                this.indexedTriangleFans(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n = 24;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 6;
        while (--n2 >= 0) {
            nArray[n2 * 4] = n2 * 4;
            nArray[n2 * 4 + 1] = n2 * 4 + 1;
            nArray[n2 * 4 + 2] = n2 * 4 + 2;
            nArray[n2 * 4 + 3] = n2 * 4 + 3;
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n = 36;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 6;
        while (--n2 >= 0) {
            nArray[n2 * 6] = n2 * 4;
            nArray[n2 * 6 + 1] = n2 * 4 + 1;
            nArray[n2 * 6 + 2] = n2 * 4 + 2;
            nArray[n2 * 6 + 3] = n2 * 4 + 2;
            nArray[n2 * 6 + 4] = n2 * 4 + 3;
            nArray[n2 * 6 + 5] = n2 * 4;
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n = 6;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.stripCounts.length, n);
        }
        int[] nArray = geometryData.stripCounts;
        float[] fArray = geometryData.coordinates;
        geometryData.numStrips = n;
        int n2 = 6;
        while (--n2 >= 0) {
            geometryData.stripCounts[n2] = 4;
            float f = fArray[n2 * 12];
            float f2 = fArray[n2 * 12 + 1];
            float f3 = fArray[n2 * 12 + 2];
            fArray[n2 * 12] = fArray[n2 * 12 + 3];
            fArray[n2 * 12 + 1] = fArray[n2 * 12 + 4];
            fArray[n2 * 12 + 2] = fArray[n2 * 12 + 5];
            fArray[n2 * 12 + 3] = fArray[n2 * 12 + 6];
            fArray[n2 * 12 + 4] = fArray[n2 * 12 + 7];
            fArray[n2 * 12 + 5] = fArray[n2 * 12 + 8];
            fArray[n2 * 12 + 6] = f;
            fArray[n2 * 12 + 7] = f2;
            fArray[n2 * 12 + 8] = f3;
        }
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n = 6;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.stripCounts.length, n);
        }
        int[] nArray = geometryData.stripCounts;
        geometryData.numStrips = n;
        int n2 = 6;
        while (--n2 >= 0) {
            nArray[n2] = 4;
        }
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n = 24;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[6];
        } else if (geometryData.stripCounts.length < 6) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, 6);
        }
        int[] nArray = geometryData.stripCounts;
        int[] nArray2 = geometryData.indexes;
        geometryData.indexesCount = n;
        geometryData.numStrips = 6;
        int n2 = 6;
        while (--n2 >= 0) {
            nArray[n2] = 4;
            nArray2[n2 * 4] = n2 * 4 + 1;
            nArray2[n2 * 4 + 1] = n2 * 4 + 2;
            nArray2[n2 * 4 + 2] = n2 * 4;
            nArray2[n2 * 4 + 3] = n2 * 4 + 3;
        }
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n = 24;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[6];
        } else if (geometryData.stripCounts.length < 6) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, 6);
        }
        int[] nArray = geometryData.stripCounts;
        int[] nArray2 = geometryData.indexes;
        geometryData.indexesCount = n;
        geometryData.numStrips = 6;
        int n2 = 6;
        while (--n2 >= 0) {
            nArray[n2] = 4;
            nArray2[n2 * 4] = n2 * 4;
            nArray2[n2 * 4 + 1] = n2 * 4 + 1;
            nArray2[n2 * 4 + 2] = n2 * 4 + 2;
            nArray2[n2 * 4 + 3] = n2 * 4 + 3;
        }
    }

    private void generateUnindexedCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[72];
        } else if (geometryData.coordinates.length < 72) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, 72);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = 24;
        float f = this.boxWidth / 2.0f;
        float f2 = this.boxHeight / 2.0f;
        float f3 = this.boxDepth / 2.0f;
        fArray[0] = f;
        fArray[1] = -f2;
        fArray[2] = f3;
        fArray[3] = f;
        fArray[4] = f2;
        fArray[5] = f3;
        fArray[6] = -f;
        fArray[7] = f2;
        fArray[8] = f3;
        fArray[9] = -f;
        fArray[10] = -f2;
        fArray[11] = f3;
        fArray[12] = -f;
        fArray[13] = -f2;
        fArray[14] = f3;
        fArray[15] = -f;
        fArray[16] = f2;
        fArray[17] = f3;
        fArray[18] = -f;
        fArray[19] = f2;
        fArray[20] = -f3;
        fArray[21] = -f;
        fArray[22] = -f2;
        fArray[23] = -f3;
        fArray[24] = -f;
        fArray[25] = -f2;
        fArray[26] = -f3;
        fArray[27] = -f;
        fArray[28] = f2;
        fArray[29] = -f3;
        fArray[30] = f;
        fArray[31] = f2;
        fArray[32] = -f3;
        fArray[33] = f;
        fArray[34] = -f2;
        fArray[35] = -f3;
        fArray[36] = f;
        fArray[37] = -f2;
        fArray[38] = -f3;
        fArray[39] = f;
        fArray[40] = f2;
        fArray[41] = -f3;
        fArray[42] = f;
        fArray[43] = f2;
        fArray[44] = f3;
        fArray[45] = f;
        fArray[46] = -f2;
        fArray[47] = f3;
        fArray[48] = f;
        fArray[49] = f2;
        fArray[50] = f3;
        fArray[51] = f;
        fArray[52] = f2;
        fArray[53] = -f3;
        fArray[54] = -f;
        fArray[55] = f2;
        fArray[56] = -f3;
        fArray[57] = -f;
        fArray[58] = f2;
        fArray[59] = f3;
        fArray[60] = -f;
        fArray[61] = -f2;
        fArray[62] = -f3;
        fArray[63] = f;
        fArray[64] = -f2;
        fArray[65] = -f3;
        fArray[66] = f;
        fArray[67] = -f2;
        fArray[68] = f3;
        fArray[69] = -f;
        fArray[70] = -f2;
        fArray[71] = f3;
    }

    private void generateUnindexedNormals(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.normals == null) {
            geometryData.normals = new float[72];
        } else if (geometryData.normals.length < 72) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, 72);
        }
        float[] fArray = geometryData.normals;
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        fArray[2] = 1.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = 1.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        fArray[9] = 0.0f;
        fArray[10] = 0.0f;
        fArray[11] = 1.0f;
        fArray[12] = -1.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        fArray[15] = -1.0f;
        fArray[16] = 0.0f;
        fArray[17] = 0.0f;
        fArray[18] = -1.0f;
        fArray[19] = 0.0f;
        fArray[20] = 0.0f;
        fArray[21] = -1.0f;
        fArray[22] = 0.0f;
        fArray[23] = 0.0f;
        fArray[24] = 0.0f;
        fArray[25] = 0.0f;
        fArray[26] = -1.0f;
        fArray[27] = 0.0f;
        fArray[28] = 0.0f;
        fArray[29] = -1.0f;
        fArray[30] = 0.0f;
        fArray[31] = 0.0f;
        fArray[32] = -1.0f;
        fArray[33] = 0.0f;
        fArray[34] = 0.0f;
        fArray[35] = -1.0f;
        fArray[36] = 1.0f;
        fArray[37] = 0.0f;
        fArray[38] = 0.0f;
        fArray[39] = 1.0f;
        fArray[40] = 0.0f;
        fArray[41] = 0.0f;
        fArray[42] = 1.0f;
        fArray[43] = 0.0f;
        fArray[44] = 0.0f;
        fArray[45] = 1.0f;
        fArray[46] = 0.0f;
        fArray[47] = 0.0f;
        fArray[48] = 0.0f;
        fArray[49] = 1.0f;
        fArray[50] = 0.0f;
        fArray[51] = 0.0f;
        fArray[52] = 1.0f;
        fArray[53] = 0.0f;
        fArray[54] = 0.0f;
        fArray[55] = 1.0f;
        fArray[56] = 0.0f;
        fArray[57] = 0.0f;
        fArray[58] = 1.0f;
        fArray[59] = 0.0f;
        fArray[60] = 0.0f;
        fArray[61] = -1.0f;
        fArray[62] = 0.0f;
        fArray[63] = 0.0f;
        fArray[64] = -1.0f;
        fArray[65] = 0.0f;
        fArray[66] = 0.0f;
        fArray[67] = -1.0f;
        fArray[68] = 0.0f;
        fArray[69] = 0.0f;
        fArray[70] = -1.0f;
        fArray[71] = 0.0f;
    }

    private void generateTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[48];
        } else if (geometryData.textureCoordinates.length < 48) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, 48);
        }
        float[] fArray = geometryData.textureCoordinates;
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 1.0f;
        fArray[3] = 1.0f;
        fArray[4] = 0.0f;
        fArray[5] = 1.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        fArray[9] = 0.0f;
        fArray[10] = 1.0f;
        fArray[11] = 1.0f;
        fArray[12] = 0.0f;
        fArray[13] = 1.0f;
        fArray[14] = 0.0f;
        fArray[15] = 0.0f;
        fArray[16] = 1.0f;
        fArray[17] = 0.0f;
        fArray[18] = 1.0f;
        fArray[19] = 1.0f;
        fArray[20] = 0.0f;
        fArray[21] = 1.0f;
        fArray[22] = 0.0f;
        fArray[23] = 0.0f;
        fArray[24] = 1.0f;
        fArray[25] = 0.0f;
        fArray[26] = 1.0f;
        fArray[27] = 1.0f;
        fArray[28] = 0.0f;
        fArray[29] = 1.0f;
        fArray[30] = 0.0f;
        fArray[31] = 0.0f;
        fArray[32] = 1.0f;
        fArray[33] = 0.0f;
        fArray[34] = 1.0f;
        fArray[35] = 1.0f;
        fArray[36] = 0.0f;
        fArray[37] = 1.0f;
        fArray[38] = 0.0f;
        fArray[39] = 0.0f;
        fArray[40] = 0.0f;
        fArray[41] = 0.0f;
        fArray[42] = 1.0f;
        fArray[43] = 0.0f;
        fArray[44] = 1.0f;
        fArray[45] = 1.0f;
        fArray[46] = 0.0f;
        fArray[47] = 1.0f;
    }

    private void generateTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[72];
        } else if (geometryData.textureCoordinates.length < 72) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, 72);
        }
        float[] fArray = geometryData.textureCoordinates;
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 1.0f;
        fArray[4] = 1.0f;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 1.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = 0.0f;
        fArray[11] = 0.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        fArray[15] = 0.0f;
        fArray[16] = 1.0f;
        fArray[17] = 0.0f;
        fArray[18] = 0.0f;
        fArray[19] = 1.0f;
        fArray[20] = 1.0f;
        fArray[21] = 0.0f;
        fArray[22] = 0.0f;
        fArray[23] = 1.0f;
        fArray[24] = 0.0f;
        fArray[25] = 0.0f;
        fArray[26] = 1.0f;
        fArray[27] = 0.0f;
        fArray[28] = 1.0f;
        fArray[29] = 1.0f;
        fArray[30] = 1.0f;
        fArray[31] = 1.0f;
        fArray[32] = 1.0f;
        fArray[33] = 1.0f;
        fArray[34] = 0.0f;
        fArray[35] = 1.0f;
        fArray[36] = 1.0f;
        fArray[37] = 0.0f;
        fArray[38] = 1.0f;
        fArray[39] = 1.0f;
        fArray[40] = 1.0f;
        fArray[41] = 1.0f;
        fArray[42] = 1.0f;
        fArray[43] = 1.0f;
        fArray[44] = 0.0f;
        fArray[45] = 1.0f;
        fArray[46] = 0.0f;
        fArray[47] = 0.0f;
        fArray[48] = 1.0f;
        fArray[49] = 1.0f;
        fArray[50] = 0.0f;
        fArray[51] = 1.0f;
        fArray[52] = 1.0f;
        fArray[53] = 1.0f;
        fArray[54] = 0.0f;
        fArray[55] = 1.0f;
        fArray[56] = 1.0f;
        fArray[57] = 0.0f;
        fArray[58] = 1.0f;
        fArray[59] = 0.0f;
        fArray[60] = 0.0f;
        fArray[61] = 0.0f;
        fArray[62] = 1.0f;
        fArray[63] = 0.0f;
        fArray[64] = 1.0f;
        fArray[65] = 1.0f;
        fArray[66] = 1.0f;
        fArray[67] = 1.0f;
        fArray[68] = 1.0f;
        fArray[69] = 1.0f;
        fArray[70] = 0.0f;
        fArray[71] = 1.0f;
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[108];
        } else if (geometryData.coordinates.length < 108) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, 108);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = 36;
        float f = this.boxWidth / 2.0f;
        float f2 = this.boxHeight / 2.0f;
        float f3 = this.boxDepth / 2.0f;
        fArray[0] = f;
        fArray[1] = -f2;
        fArray[2] = f3;
        fArray[3] = f;
        fArray[4] = f2;
        fArray[5] = f3;
        fArray[6] = -f;
        fArray[7] = f2;
        fArray[8] = f3;
        fArray[9] = -f;
        fArray[10] = f2;
        fArray[11] = f3;
        fArray[12] = -f;
        fArray[13] = -f2;
        fArray[14] = f3;
        fArray[15] = f;
        fArray[16] = -f2;
        fArray[17] = f3;
        fArray[18] = -f;
        fArray[19] = -f2;
        fArray[20] = f3;
        fArray[21] = -f;
        fArray[22] = f2;
        fArray[23] = f3;
        fArray[24] = -f;
        fArray[25] = f2;
        fArray[26] = -f3;
        fArray[27] = -f;
        fArray[28] = f2;
        fArray[29] = -f3;
        fArray[30] = -f;
        fArray[31] = -f2;
        fArray[32] = -f3;
        fArray[33] = -f;
        fArray[34] = -f2;
        fArray[35] = f3;
        fArray[36] = -f;
        fArray[37] = -f2;
        fArray[38] = -f3;
        fArray[39] = -f;
        fArray[40] = f2;
        fArray[41] = -f3;
        fArray[42] = f;
        fArray[43] = f2;
        fArray[44] = -f3;
        fArray[45] = f;
        fArray[46] = f2;
        fArray[47] = -f3;
        fArray[48] = f;
        fArray[49] = -f2;
        fArray[50] = -f3;
        fArray[51] = -f;
        fArray[52] = -f2;
        fArray[53] = -f3;
        fArray[54] = f;
        fArray[55] = -f2;
        fArray[56] = -f3;
        fArray[57] = f;
        fArray[58] = f2;
        fArray[59] = -f3;
        fArray[60] = f;
        fArray[61] = f2;
        fArray[62] = f3;
        fArray[63] = f;
        fArray[64] = f2;
        fArray[65] = f3;
        fArray[66] = f;
        fArray[67] = -f2;
        fArray[68] = f3;
        fArray[69] = f;
        fArray[70] = -f2;
        fArray[71] = -f3;
        fArray[72] = f;
        fArray[73] = f2;
        fArray[74] = f3;
        fArray[75] = f;
        fArray[76] = f2;
        fArray[77] = -f3;
        fArray[78] = -f;
        fArray[79] = f2;
        fArray[80] = -f3;
        fArray[81] = -f;
        fArray[82] = f2;
        fArray[83] = -f3;
        fArray[84] = -f;
        fArray[85] = f2;
        fArray[86] = f3;
        fArray[87] = f;
        fArray[88] = f2;
        fArray[89] = f3;
        fArray[90] = -f;
        fArray[91] = -f2;
        fArray[92] = -f3;
        fArray[93] = f;
        fArray[94] = -f2;
        fArray[95] = -f3;
        fArray[96] = f;
        fArray[97] = -f2;
        fArray[98] = f3;
        fArray[99] = f;
        fArray[100] = -f2;
        fArray[101] = f3;
        fArray[102] = -f;
        fArray[103] = -f2;
        fArray[104] = f3;
        fArray[105] = -f;
        fArray[106] = -f2;
        fArray[107] = -f3;
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.normals == null) {
            geometryData.normals = new float[108];
        } else if (geometryData.normals.length < 108) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, 108);
        }
        float[] fArray = geometryData.normals;
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        fArray[2] = 1.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = 1.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        fArray[9] = 0.0f;
        fArray[10] = 0.0f;
        fArray[11] = 1.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 1.0f;
        fArray[15] = 0.0f;
        fArray[16] = 0.0f;
        fArray[17] = 1.0f;
        fArray[18] = -1.0f;
        fArray[19] = 0.0f;
        fArray[20] = 0.0f;
        fArray[21] = -1.0f;
        fArray[22] = 0.0f;
        fArray[23] = 0.0f;
        fArray[24] = -1.0f;
        fArray[25] = 0.0f;
        fArray[26] = 0.0f;
        fArray[27] = -1.0f;
        fArray[28] = 0.0f;
        fArray[29] = 0.0f;
        fArray[30] = -1.0f;
        fArray[31] = 0.0f;
        fArray[32] = 0.0f;
        fArray[33] = -1.0f;
        fArray[34] = 0.0f;
        fArray[35] = 0.0f;
        fArray[36] = 0.0f;
        fArray[37] = 0.0f;
        fArray[38] = -1.0f;
        fArray[39] = 0.0f;
        fArray[40] = 0.0f;
        fArray[41] = -1.0f;
        fArray[42] = 0.0f;
        fArray[43] = 0.0f;
        fArray[44] = -1.0f;
        fArray[45] = 0.0f;
        fArray[46] = 0.0f;
        fArray[47] = -1.0f;
        fArray[48] = 0.0f;
        fArray[49] = 0.0f;
        fArray[50] = -1.0f;
        fArray[51] = 0.0f;
        fArray[52] = 0.0f;
        fArray[53] = -1.0f;
        fArray[54] = 1.0f;
        fArray[55] = 0.0f;
        fArray[56] = 0.0f;
        fArray[57] = 1.0f;
        fArray[58] = 0.0f;
        fArray[59] = 0.0f;
        fArray[60] = 1.0f;
        fArray[61] = 0.0f;
        fArray[62] = 0.0f;
        fArray[63] = 1.0f;
        fArray[64] = 0.0f;
        fArray[65] = 0.0f;
        fArray[66] = 1.0f;
        fArray[67] = 0.0f;
        fArray[68] = 0.0f;
        fArray[69] = 1.0f;
        fArray[70] = 0.0f;
        fArray[71] = 0.0f;
        fArray[72] = 0.0f;
        fArray[73] = 1.0f;
        fArray[74] = 0.0f;
        fArray[75] = 0.0f;
        fArray[76] = 1.0f;
        fArray[77] = 0.0f;
        fArray[78] = 0.0f;
        fArray[79] = 1.0f;
        fArray[80] = 0.0f;
        fArray[81] = 0.0f;
        fArray[82] = 1.0f;
        fArray[83] = 0.0f;
        fArray[84] = 0.0f;
        fArray[85] = 1.0f;
        fArray[86] = 0.0f;
        fArray[87] = 0.0f;
        fArray[88] = 1.0f;
        fArray[91] = 0.0f;
        fArray[90] = 0.0f;
        fArray[91] = -1.0f;
        fArray[92] = 0.0f;
        fArray[93] = 0.0f;
        fArray[94] = -1.0f;
        fArray[95] = 0.0f;
        fArray[96] = 0.0f;
        fArray[97] = -1.0f;
        fArray[98] = 0.0f;
        fArray[99] = 0.0f;
        fArray[100] = -1.0f;
        fArray[101] = 0.0f;
        fArray[102] = 0.0f;
        fArray[103] = -1.0f;
        fArray[104] = 0.0f;
        fArray[105] = 0.0f;
        fArray[106] = -1.0f;
        fArray[107] = 0.0f;
    }

    private void generateTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[72];
        } else if (geometryData.textureCoordinates.length < 72) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, 72);
        }
        float[] fArray = geometryData.textureCoordinates;
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 1.0f;
        fArray[3] = 1.0f;
        fArray[4] = 0.0f;
        fArray[5] = 1.0f;
        fArray[6] = 0.0f;
        fArray[7] = 1.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = 1.0f;
        fArray[11] = 0.0f;
        fArray[12] = 1.0f;
        fArray[13] = 0.0f;
        fArray[14] = 1.0f;
        fArray[15] = 1.0f;
        fArray[16] = 0.0f;
        fArray[17] = 1.0f;
        fArray[18] = 0.0f;
        fArray[19] = 1.0f;
        fArray[20] = 0.0f;
        fArray[21] = 0.0f;
        fArray[22] = 1.0f;
        fArray[23] = 0.0f;
        fArray[24] = 1.0f;
        fArray[25] = 0.0f;
        fArray[26] = 1.0f;
        fArray[27] = 1.0f;
        fArray[28] = 0.0f;
        fArray[29] = 1.0f;
        fArray[30] = 0.0f;
        fArray[31] = 1.0f;
        fArray[32] = 0.0f;
        fArray[33] = 0.0f;
        fArray[34] = 1.0f;
        fArray[35] = 0.0f;
        fArray[36] = 1.0f;
        fArray[37] = 0.0f;
        fArray[38] = 1.0f;
        fArray[39] = 1.0f;
        fArray[40] = 0.0f;
        fArray[41] = 1.0f;
        fArray[42] = 0.0f;
        fArray[43] = 1.0f;
        fArray[44] = 0.0f;
        fArray[45] = 0.0f;
        fArray[46] = 1.0f;
        fArray[47] = 0.0f;
        fArray[48] = 1.0f;
        fArray[49] = 0.0f;
        fArray[50] = 1.0f;
        fArray[51] = 1.0f;
        fArray[52] = 0.0f;
        fArray[53] = 1.0f;
        fArray[54] = 0.0f;
        fArray[55] = 1.0f;
        fArray[56] = 0.0f;
        fArray[57] = 0.0f;
        fArray[58] = 1.0f;
        fArray[59] = 0.0f;
        fArray[60] = 0.0f;
        fArray[61] = 0.0f;
        fArray[62] = 1.0f;
        fArray[63] = 0.0f;
        fArray[64] = 1.0f;
        fArray[65] = 1.0f;
        fArray[66] = 1.0f;
        fArray[67] = 1.0f;
        fArray[68] = 0.0f;
        fArray[69] = 1.0f;
        fArray[70] = 0.0f;
        fArray[71] = 0.0f;
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[108];
        } else if (geometryData.textureCoordinates.length < 108) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, 108);
        }
        float[] fArray = geometryData.textureCoordinates;
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 1.0f;
        fArray[4] = 1.0f;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 1.0f;
        fArray[8] = 0.0f;
        fArray[9] = 0.0f;
        fArray[10] = 1.0f;
        fArray[11] = 0.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        fArray[15] = 1.0f;
        fArray[16] = 0.0f;
        fArray[17] = 0.0f;
        fArray[18] = 0.0f;
        fArray[19] = 0.0f;
        fArray[20] = 0.0f;
        fArray[21] = 0.0f;
        fArray[22] = 1.0f;
        fArray[23] = 0.0f;
        fArray[24] = 0.0f;
        fArray[25] = 1.0f;
        fArray[26] = 1.0f;
        fArray[27] = 0.0f;
        fArray[28] = 1.0f;
        fArray[29] = 1.0f;
        fArray[30] = 0.0f;
        fArray[31] = 0.0f;
        fArray[32] = 1.0f;
        fArray[33] = 0.0f;
        fArray[34] = 0.0f;
        fArray[35] = 0.0f;
        fArray[36] = 0.0f;
        fArray[37] = 0.0f;
        fArray[38] = 1.0f;
        fArray[39] = 0.0f;
        fArray[40] = 1.0f;
        fArray[41] = 1.0f;
        fArray[42] = 1.0f;
        fArray[43] = 1.0f;
        fArray[44] = 1.0f;
        fArray[45] = 1.0f;
        fArray[46] = 1.0f;
        fArray[47] = 1.0f;
        fArray[48] = 1.0f;
        fArray[49] = 0.0f;
        fArray[50] = 1.0f;
        fArray[51] = 0.0f;
        fArray[52] = 0.0f;
        fArray[53] = 1.0f;
        fArray[54] = 1.0f;
        fArray[55] = 0.0f;
        fArray[56] = 1.0f;
        fArray[57] = 1.0f;
        fArray[58] = 1.0f;
        fArray[59] = 1.0f;
        fArray[60] = 1.0f;
        fArray[61] = 1.0f;
        fArray[62] = 0.0f;
        fArray[63] = 1.0f;
        fArray[64] = 1.0f;
        fArray[65] = 0.0f;
        fArray[66] = 1.0f;
        fArray[67] = 0.0f;
        fArray[68] = 0.0f;
        fArray[69] = 1.0f;
        fArray[70] = 0.0f;
        fArray[71] = 1.0f;
        fArray[72] = 1.0f;
        fArray[72] = 1.0f;
        fArray[74] = 0.0f;
        fArray[75] = 1.0f;
        fArray[75] = 1.0f;
        fArray[77] = 1.0f;
        fArray[78] = 0.0f;
        fArray[78] = 1.0f;
        fArray[80] = 1.0f;
        fArray[81] = 0.0f;
        fArray[81] = 1.0f;
        fArray[83] = 1.0f;
        fArray[84] = 0.0f;
        fArray[84] = 1.0f;
        fArray[86] = 0.0f;
        fArray[87] = 1.0f;
        fArray[87] = 1.0f;
        fArray[89] = 0.0f;
        fArray[90] = 0.0f;
        fArray[91] = 0.0f;
        fArray[92] = 1.0f;
        fArray[93] = 0.0f;
        fArray[94] = 1.0f;
        fArray[95] = 1.0f;
        fArray[96] = 1.0f;
        fArray[97] = 1.0f;
        fArray[98] = 1.0f;
        fArray[99] = 1.0f;
        fArray[100] = 1.0f;
        fArray[101] = 1.0f;
        fArray[102] = 1.0f;
        fArray[103] = 0.0f;
        fArray[104] = 1.0f;
        fArray[105] = 0.0f;
        fArray[106] = 0.0f;
        fArray[107] = 1.0f;
    }
}

