/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3f;

public class RasterTextLabel
extends Shape3D {
    private static final int BORDER_INSETS = 2;
    private Color textColor;
    private Color borderColor;
    private Font labelFont;

    public RasterTextLabel() {
        this(null, null, 0.0f, 0.0f, 0.0f, null, null);
    }

    public RasterTextLabel(String string, Color color) {
        this(string, color, 0.0f, 0.0f, 0.0f, null, null);
    }

    public RasterTextLabel(String string, Color color, float f, float f2, float f3) {
        this(string, color, f, f2, f3, null, null);
    }

    public RasterTextLabel(String string, Color color, float f, float f2, float f3, Color color2, Font font) {
        this.textColor = color;
        this.borderColor = color2;
        this.labelFont = font;
        Appearance appearance = new Appearance();
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setDepthBufferEnable(false);
        renderingAttributes.setDepthBufferWriteEnable(false);
        appearance.setRenderingAttributes(renderingAttributes);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes(0, 1.0f);
        appearance.setTransparencyAttributes(transparencyAttributes);
        this.setAppearance(appearance);
        if (string == null) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics graphics = bufferedImage.getGraphics();
        FontMetrics fontMetrics = font == null ? graphics.getFontMetrics() : graphics.getFontMetrics(font);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
        graphics.dispose();
        bufferedImage.flush();
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        int n3 = fontMetrics.getMaxAscent();
        if (color2 != null) {
            n += 6;
            n2 += 6;
        }
        bufferedImage = new BufferedImage(n, n2, 2);
        graphics = bufferedImage.getGraphics();
        if (color2 != null) {
            graphics.setColor(this.borderColor);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
            if (this.textColor == null) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(this.textColor);
            }
            graphics.drawString(string, 3, n3 + 2 + 1);
        } else {
            if (this.textColor == null) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(this.textColor);
            }
            graphics.drawString(string, 0, n3);
        }
        graphics.dispose();
        ImageComponent2D imageComponent2D = new ImageComponent2D(2, bufferedImage);
        Point3f point3f = new Point3f(f, f2, f3);
        Raster raster = new Raster(point3f, 1, 0, 0, n, n2, imageComponent2D, null);
        this.setGeometry((Geometry)raster);
    }

    public void setLabel(String string) {
    }

    public void setLabel(String string, Color color) {
    }

    public void fixSize(boolean bl) {
    }
}

