/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.j3d.geom.BoxGenerator;
import org.j3d.geom.GeometryData;

public class TestBoxGenerator
extends TestCase {
    private static final float[] TEST_BOX = new float[]{0.4f, 1.0f, 6.8f};
    private BoxGenerator generator;

    public TestBoxGenerator(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestBoxGenerator("testCreate"));
        testSuite.addTest((Test)new TestBoxGenerator("testCoordinateArray"));
        testSuite.addTest((Test)new TestBoxGenerator("testNormalArray"));
        return testSuite;
    }

    public void testCreate() {
        this.generator = new BoxGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Default box vertex count is wrong", (int)36, (int)geometryData.vertexCount);
        float[] fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Default box width wrong", (float)2.0f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Default box height wrong", (float)2.0f, (float)fArray[1], (float)0.0f);
        Assert.assertEquals((String)"Default box depth wrong", (float)2.0f, (float)fArray[2], (float)0.0f);
        this.generator.setDimensions(TEST_BOX[0], TEST_BOX[1], TEST_BOX[2]);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Dimensions vertex count is wrong", (int)36, (int)geometryData.vertexCount);
        fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Dimensions width wrong", (float)TEST_BOX[0], (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Dimensions height wrong", (float)TEST_BOX[1], (float)fArray[1], (float)0.0f);
        Assert.assertEquals((String)"Dimensions depth wrong", (float)TEST_BOX[2], (float)fArray[2], (float)0.0f);
        this.generator = new BoxGenerator(TEST_BOX[0], TEST_BOX[1], TEST_BOX[2]);
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Test box vertex count is wrong", (int)36, (int)geometryData.vertexCount);
        fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Test box width wrong", (float)TEST_BOX[0], (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Test box height wrong", (float)TEST_BOX[1], (float)fArray[1], (float)0.0f);
        Assert.assertEquals((String)"Test box depth wrong", (float)TEST_BOX[2], (float)fArray[2], (float)0.0f);
    }

    public void testCoordinateArray() {
        this.generator = new BoxGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Default box coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(TEST_BOX[0], TEST_BOX[1], TEST_BOX[2]);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Dimensioned box coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new BoxGenerator(TEST_BOX[0], TEST_BOX[1], TEST_BOX[2]);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Test box coordinate length wrong", (int)(n * 3), (int)fArray.length);
    }

    public void testNormalArray() {
        this.generator = new BoxGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        geometryData.geometryComponents = 2;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.normals;
        Assert.assertEquals((String)"Default box normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(TEST_BOX[0], TEST_BOX[1], TEST_BOX[2]);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Dimensioned box normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new BoxGenerator(TEST_BOX[0], TEST_BOX[1], TEST_BOX[2]);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Test box normal length wrong", (int)(n * 3), (int)fArray.length);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestBoxGenerator.suite());
    }
}

