/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.j3d.geom.ConeGenerator;
import org.j3d.geom.GeometryData;

public class TestConeGenerator
extends TestCase {
    private static final float TEST_HEIGHT = 1.4f;
    private static final float TEST_RADIUS = 0.5f;
    private static final int[] VALID_FACETS = new int[]{13, 6, 10};
    private static final int[] INVALID_FACETS = new int[]{-5, 0, 2};
    private ConeGenerator generator;

    public TestConeGenerator(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestConeGenerator("testCreate"));
        testSuite.addTest((Test)new TestConeGenerator("testCoordinateArray"));
        testSuite.addTest((Test)new TestConeGenerator("testNormalArray"));
        testSuite.addTest((Test)new TestConeGenerator("testInvalidFacets"));
        testSuite.addTest((Test)new TestConeGenerator("testValidFacets"));
        return testSuite;
    }

    public void testCreate() {
        this.generator = new ConeGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        this.generator.generate(geometryData);
        Assert.assertTrue((String)"Default cone is missing the bottom", (boolean)this.generator.hasBottom());
        Assert.assertEquals((String)"Default cone vertex count is wrong", (int)96, (int)geometryData.vertexCount);
        float[] fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Default cone height wrong", (float)2.0f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Default cone radius wrong", (float)1.0f, (float)fArray[1], (float)0.0f);
        this.generator.setDimensions(1.4f, 0.5f, true);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertTrue((String)"Dimensioned cone is missing the bottom", (boolean)this.generator.hasBottom());
        Assert.assertEquals((String)"Dimensioned vertex count is wrong", (int)96, (int)geometryData.vertexCount);
        fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Dimensioned cone radius wrong", (float)1.4f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Dimensioned cone height wrong", (float)0.5f, (float)fArray[1], (float)0.0f);
        this.generator.setDimensions(1.4f, 0.5f, false);
        Assert.assertTrue((String)"Dimensioned cone bottom check is wrong", (!this.generator.hasBottom() ? 1 : 0) != 0);
        this.generator = new ConeGenerator(1.4f, 0.5f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertTrue((String)"Test cone is missing the bottom", (boolean)this.generator.hasBottom());
        Assert.assertEquals((String)"Test cone vertex count is wrong", (int)96, (int)geometryData.vertexCount);
        fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Test cone radius wrong", (float)1.4f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Test cone height wrong", (float)0.5f, (float)fArray[1], (float)0.0f);
    }

    public void testCoordinateArray() {
        this.generator = new ConeGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Default cone coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(1.4f, 0.5f, true);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Dimensioned cone coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new ConeGenerator(1.4f, 0.5f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Test cone coordinate length wrong", (int)(n * 3), (int)fArray.length);
        int n2 = n;
        this.generator = new ConeGenerator(1.4f, 0.5f, false);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"No-bottom code vertex count wrong", (int)(n2 / 2), (int)n);
        Assert.assertEquals((String)"No-bottom cone coordinate length wrong", (int)(n * 3), (int)fArray.length);
    }

    public void testNormalArray() {
        this.generator = new ConeGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        geometryData.geometryComponents = 2;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.normals;
        Assert.assertEquals((String)"Default cone normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(1.4f, 0.5f, true);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Dimensioned cone normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new ConeGenerator(1.4f, 0.5f);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Test cone normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new ConeGenerator(1.4f, 0.5f, false);
        int n2 = n;
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"No-bottom code vertex count wrong", (int)(n2 / 2), (int)n);
        Assert.assertEquals((String)"No-bottom cone coordinate length wrong", (int)(n * 3), (int)fArray.length);
    }

    public void testInvalidFacets() {
        int n = 0;
        while (n < INVALID_FACETS.length) {
            try {
                this.generator = new ConeGenerator(2.0f, 1.0f, INVALID_FACETS[n]);
                Assert.fail((String)("Did not detect bad facet count on construction " + INVALID_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        this.generator = new ConeGenerator();
        n = 0;
        while (n < INVALID_FACETS.length) {
            try {
                this.generator.setFacetCount(INVALID_FACETS[n]);
                Assert.fail((String)("Did not detect invalid facet count on set " + INVALID_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testValidFacets() {
        int n;
        int n2;
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        int n3 = 0;
        while (n3 < VALID_FACETS.length) {
            this.generator = new ConeGenerator(2.0f, 1.0f, VALID_FACETS[n3]);
            n2 = VALID_FACETS[n3] * 6;
            geometryData.coordinates = null;
            this.generator.generate(geometryData);
            n = geometryData.vertexCount;
            Assert.assertEquals((String)("Construct vertex count wrong for " + VALID_FACETS[n3]), (int)n2, (int)n);
            Assert.assertEquals((String)("Generated initial vertex count wrong for " + VALID_FACETS[n3]), (int)(n2 *= 3), (int)geometryData.coordinates.length);
            ++n3;
        }
        this.generator = new ConeGenerator();
        n3 = 0;
        while (n3 < VALID_FACETS.length) {
            this.generator.setFacetCount(VALID_FACETS[n3]);
            n2 = VALID_FACETS[n3] * 6;
            geometryData.coordinates = null;
            this.generator.generate(geometryData);
            n = geometryData.vertexCount;
            Assert.assertEquals((String)("Set vertex count wrong for " + VALID_FACETS[n3]), (int)n2, (int)n);
            Assert.assertEquals((String)("Generated set vertex count wrong for " + VALID_FACETS[n3]), (int)(n2 *= 3), (int)geometryData.coordinates.length);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestConeGenerator.suite());
    }
}

