/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.j3d.geom.GeometryData;
import org.j3d.geom.SphereGenerator;

public class TestSphereGenerator
extends TestCase {
    private static final float TEST_RADIUS = 0.5f;
    private static final int[] VALID_FACETS = new int[]{12, 32, 72};
    private static final int[] INVALID_FACETS = new int[]{-5, 0, 2, 7};
    private SphereGenerator generator;

    public TestSphereGenerator(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestSphereGenerator("testCreate"));
        testSuite.addTest((Test)new TestSphereGenerator("testCoordinateArray"));
        testSuite.addTest((Test)new TestSphereGenerator("testNormalArray"));
        testSuite.addTest((Test)new TestSphereGenerator("testInvalidFacets"));
        testSuite.addTest((Test)new TestSphereGenerator("testValidFacets"));
        return testSuite;
    }

    public void testCreate() {
        this.generator = new SphereGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        this.generator.generate(geometryData);
        Assert.assertTrue((String)"Default sphere is missing the bottom", (!this.generator.isHalf() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Default sphere vertex count is wrong", (int)1536, (int)geometryData.vertexCount);
        float f = this.generator.getDimension();
        Assert.assertEquals((String)"Default sphere radius wrong", (float)1.0f, (float)f, (float)0.0f);
        this.generator.setDimensions(0.5f, false);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertTrue((String)"Dimensioned sphere is missing the bottom", (!this.generator.isHalf() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Dimensioned vertex count is wrong", (int)1536, (int)geometryData.vertexCount);
        f = this.generator.getDimension();
        Assert.assertEquals((String)"Dimensioned sphere radius wrong", (float)0.5f, (float)f, (float)0.0f);
        this.generator.setDimensions(0.5f, true);
        Assert.assertTrue((String)"Dimensioned sphere bottom check is wrong", (boolean)this.generator.isHalf());
        this.generator = new SphereGenerator(0.5f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertTrue((String)"Test sphere is missing the bottom", (!this.generator.isHalf() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Test sphere vertex count is wrong", (int)1536, (int)geometryData.vertexCount);
        f = this.generator.getDimension();
        Assert.assertEquals((String)"Test sphere radius wrong", (float)0.5f, (float)f, (float)0.0f);
    }

    public void testCoordinateArray() {
        this.generator = new SphereGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Default sphere coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(0.5f, false);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Dimensioned sphere coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new SphereGenerator(0.5f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Test sphere coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new SphereGenerator(0.5f, true);
        int n2 = n;
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"No-bottom sphere vertex count wrong", (int)(n2 / 2), (int)n);
        Assert.assertEquals((String)"No-bottom sphere coordinate length wrong", (int)(n * 3), (int)fArray.length);
    }

    public void testNormalArray() {
        this.generator = new SphereGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        geometryData.geometryComponents = 2;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.normals;
        Assert.assertEquals((String)"Default sphere normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(0.5f, false);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Dimensioned sphere normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new SphereGenerator(0.5f);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Test sphere normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new SphereGenerator(0.5f, true);
        int n2 = n;
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"No-bottom sphere normal vertex count wrong", (int)(n2 / 2), (int)n);
        Assert.assertEquals((String)"No-bottom sphere normal length wrong", (int)(n * 3), (int)fArray.length);
    }

    public void testInvalidFacets() {
        int n = 0;
        while (n < INVALID_FACETS.length) {
            try {
                this.generator = new SphereGenerator(1.0f, INVALID_FACETS[n]);
                Assert.fail((String)("Did not detect bad facet count on construction " + INVALID_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        this.generator = new SphereGenerator();
        n = 0;
        while (n < INVALID_FACETS.length) {
            try {
                this.generator.setFacetCount(INVALID_FACETS[n]);
                Assert.fail((String)("Did not detect invalid facet count on set " + INVALID_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testValidFacets() {
        int n;
        int n2;
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 1;
        int n3 = 0;
        while (n3 < VALID_FACETS.length) {
            this.generator = new SphereGenerator(1.0f, VALID_FACETS[n3]);
            n2 = VALID_FACETS[n3] * VALID_FACETS[n3] * 6;
            geometryData.coordinates = null;
            this.generator.generate(geometryData);
            n = geometryData.vertexCount;
            Assert.assertEquals((String)("Construct vertex count wrong for " + VALID_FACETS[n3]), (int)n2, (int)n);
            Assert.assertEquals((String)("Generated initial vertex count wrong for " + VALID_FACETS[n3]), (int)(n2 *= 3), (int)geometryData.coordinates.length);
            ++n3;
        }
        this.generator = new SphereGenerator();
        n3 = 0;
        while (n3 < VALID_FACETS.length) {
            this.generator.setFacetCount(VALID_FACETS[n3]);
            n2 = VALID_FACETS[n3] * VALID_FACETS[n3] * 6;
            geometryData.coordinates = null;
            this.generator.generate(geometryData);
            n = geometryData.vertexCount;
            Assert.assertEquals((String)("Set vertex count wrong for " + VALID_FACETS[n3]), (int)n2, (int)n);
            Assert.assertEquals((String)("Generated set vertex count wrong for " + VALID_FACETS[n3]), (int)(n2 *= 3), (int)geometryData.coordinates.length);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestSphereGenerator.suite());
    }
}

