/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.j3d.geom.GeometryData;
import org.j3d.geom.TorusGenerator;

public class TestTorusGenerator
extends TestCase {
    private static final float TEST_INNER_RADIUS = 0.5f;
    private static final float TEST_OUTER_RADIUS = 6.3f;
    private static final int[] VALID_INNER_FACETS = new int[]{12, 32, 72};
    private static final int[] VALID_OUTER_FACETS = new int[]{10, 20, 32};
    private static final int[] INVALID_INNER_FACETS = new int[]{-5, 0, 2, 11};
    private static final int[] INVALID_OUTER_FACETS = new int[]{-5, 0, 2};
    private TorusGenerator generator;

    public TestTorusGenerator(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestTorusGenerator("testCreate"));
        testSuite.addTest((Test)new TestTorusGenerator("testCoordinateArray"));
        testSuite.addTest((Test)new TestTorusGenerator("testNormalArray"));
        testSuite.addTest((Test)new TestTorusGenerator("testInvalidFacets"));
        testSuite.addTest((Test)new TestTorusGenerator("testValidFacets"));
        return testSuite;
    }

    public void testCreate() {
        this.generator = new TorusGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 2;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Default torus vertex count", (int)1024, (int)geometryData.vertexCount);
        float[] fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Default torus inner radius", (float)0.25f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Default torus outer radius", (float)1.0f, (float)fArray[1], (float)0.0f);
        this.generator.setDimensions(0.5f, 6.3f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Dimensioned vertex count is wrong", (int)1024, (int)geometryData.vertexCount);
        fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Dimensioned torus outer radius wrong", (float)0.5f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Dimensioned torus inner radius wrong", (float)6.3f, (float)fArray[1], (float)0.0f);
        this.generator = new TorusGenerator(0.5f, 6.3f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Test torus vertex count is wrong", (int)1024, (int)geometryData.vertexCount);
        fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Test torus outer radius wrong", (float)0.5f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Test torus inner radius wrong", (float)6.3f, (float)fArray[1], (float)0.0f);
    }

    public void testCoordinateArray() {
        this.generator = new TorusGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 2;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Default torus coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(0.5f, 6.3f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Dimensioned torus coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new TorusGenerator(0.5f, 6.3f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Test torus coordinate length wrong", (int)(n * 3), (int)fArray.length);
    }

    public void testNormalArray() {
        this.generator = new TorusGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 2;
        geometryData.geometryComponents = 2;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.normals;
        Assert.assertEquals((String)"Default torus normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(0.5f, 6.3f);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Dimensioned torus normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new TorusGenerator(0.5f, 6.3f);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Test torus normal length wrong", (int)(n * 3), (int)fArray.length);
    }

    public void testInvalidFacets() {
        int n = 0;
        while (n < INVALID_INNER_FACETS.length) {
            try {
                this.generator = new TorusGenerator(INVALID_INNER_FACETS[n], 4);
                Assert.fail((String)("Did not detect bad inner facet count on construction " + INVALID_INNER_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        n = 0;
        while (n < INVALID_OUTER_FACETS.length) {
            try {
                this.generator = new TorusGenerator(4, INVALID_OUTER_FACETS[n]);
                Assert.fail((String)("Did not detect bad outer facet count on construction " + INVALID_OUTER_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        this.generator = new TorusGenerator();
        n = 0;
        while (n < INVALID_INNER_FACETS.length) {
            try {
                this.generator.setFacetCount(INVALID_INNER_FACETS[n], 4);
                Assert.fail((String)("Did not detect invalid inner facet count on set " + INVALID_OUTER_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        n = 0;
        while (n < INVALID_OUTER_FACETS.length) {
            try {
                this.generator.setFacetCount(4, INVALID_OUTER_FACETS[n]);
                Assert.fail((String)("Did not detect invalid outer facet count on set " + INVALID_OUTER_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testValidFacets() {
        float[] fArray;
        int n;
        int n2;
        Assert.assertEquals((String)"Valid inner & outer facet lengths", (int)VALID_INNER_FACETS.length, (int)VALID_OUTER_FACETS.length);
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 2;
        int n3 = 0;
        while (n3 < VALID_INNER_FACETS.length) {
            this.generator = new TorusGenerator(VALID_INNER_FACETS[n3], VALID_OUTER_FACETS[n3]);
            geometryData.coordinates = null;
            this.generator.generate(geometryData);
            n2 = VALID_INNER_FACETS[n3] * VALID_OUTER_FACETS[n3] * 4;
            n = geometryData.vertexCount;
            Assert.assertEquals((String)("Construct vertex count for inner facet" + VALID_INNER_FACETS[n3]), (int)n2, (int)n);
            fArray = geometryData.coordinates;
            Assert.assertEquals((String)("Generated initial vertex count for inner facet" + VALID_INNER_FACETS[n3]), (int)(n2 *= 3), (int)fArray.length);
            ++n3;
        }
        this.generator = new TorusGenerator();
        n3 = 0;
        while (n3 < VALID_INNER_FACETS.length) {
            this.generator.setFacetCount(VALID_INNER_FACETS[n3], VALID_OUTER_FACETS[n3]);
            n2 = VALID_INNER_FACETS[n3] * VALID_OUTER_FACETS[n3] * 4;
            geometryData.coordinates = null;
            this.generator.generate(geometryData);
            n = geometryData.vertexCount;
            Assert.assertEquals((String)("Construct vertex count for inner facet" + VALID_INNER_FACETS[n3]), (int)n2, (int)n);
            fArray = geometryData.coordinates;
            Assert.assertEquals((String)("Generated initial vertex count for inner facet" + VALID_INNER_FACETS[n3]), (int)(n2 *= 3), (int)fArray.length);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestTorusGenerator.suite());
    }
}

