/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.overlay;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3d;
import org.j3d.geom.overlay.ComponentMouseManager;
import org.j3d.geom.overlay.Overlay;
import org.j3d.geom.overlay.OverlayUtilities;
import org.j3d.geom.overlay.ScreenComponent;
import org.j3d.geom.overlay.SubOverlay;
import org.j3d.geom.overlay.UpdateControlBehavior;
import org.j3d.geom.overlay.UpdateManager;

public class OverlayBase
implements Overlay,
ScreenComponent,
ComponentListener {
    private static final double CONSOLE_Z = (double)2.1f;
    protected int backgroundMode = 1;
    protected int[] relativePosition = new int[]{1, 0};
    private BufferedImage backgroundImage;
    private boolean hasAlpha;
    private boolean visible;
    private boolean antialiased;
    private int numBuffers;
    private final int minDivSize;
    protected Rectangle overlayBounds;
    private Dimension offset;
    private UpdateManager updateManager;
    private Canvas3D canvas3D;
    protected BufferedImage canvas;
    protected Color backgroundColor;
    protected SubOverlay[] subOverlay;
    protected int activeBuffer = -1;
    protected BranchGroup consoleBG;
    protected BranchGroup overlayTexGrp;
    protected TransformGroup consoleTG;
    private RenderingAttributes renderAttributes;
    private PolygonAttributes polygonAttributes;
    private TextureAttributes textureAttributes;
    private TransparencyAttributes transparencyAttributes;
    public static final int DIRTY_VISIBLE = 0;
    public static final int DIRTY_POSITION = 1;
    public static final int DIRTY_ACTIVE_BUFFER = 2;
    public static final int DIRTY_SIZE = 3;
    private boolean[] dirtyCheck = new boolean[4];
    private boolean fixedSize;
    private ComponentMouseManager mouseManager;
    private boolean painting = false;

    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle) {
        this(canvas3D, rectangle, true, false, null);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle, UpdateManager updateManager) {
        this(canvas3D, rectangle, true, false, updateManager);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2) {
        this(canvas3D, rectangle, bl, bl2, null);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2, UpdateManager updateManager) {
        this(canvas3D, rectangle, bl, bl2, updateManager, 2);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2, UpdateManager updateManager, int n) {
        Object object;
        this.numBuffers = n;
        this.canvas3D = canvas3D;
        if (rectangle == null) {
            this.overlayBounds = canvas3D.getBounds();
            this.fixedSize = false;
            this.minDivSize = 1;
        } else {
            this.overlayBounds = rectangle;
            this.fixedSize = true;
            this.minDivSize = 16;
        }
        this.visible = true;
        this.antialiased = true;
        this.offset = new Dimension(this.overlayBounds.x, this.overlayBounds.y);
        boolean bl3 = this.hasAlpha = bl || bl2;
        if (this.overlayBounds.width != 0 && this.overlayBounds.height != 0) {
            this.canvas = OverlayUtilities.createBufferedImage(this.overlayBounds.getSize(), this.hasAlpha);
        }
        this.mouseManager = new ComponentMouseManager((Component)this.canvas3D, this);
        this.canvas3D.addComponentListener((ComponentListener)this);
        this.consoleBG = new BranchGroup();
        this.consoleBG.setCapability(13);
        this.overlayTexGrp = new BranchGroup();
        this.overlayTexGrp.setCapability(17);
        this.consoleTG = new TransformGroup();
        this.consoleTG.setCapability(18);
        this.overlayTexGrp.addChild((Node)this.consoleTG);
        this.consoleBG.addChild((Node)this.overlayTexGrp);
        if (updateManager == null) {
            object = new UpdateControlBehavior(this);
            object.setSchedulingBounds((Bounds)new BoundingSphere());
            this.consoleBG.addChild((Node)object);
            this.updateManager = object;
        } else {
            this.updateManager = updateManager;
        }
        this.renderAttributes = new RenderingAttributes();
        if (bl) {
            this.renderAttributes.setAlphaTestFunction(3);
            this.renderAttributes.setAlphaTestValue(0.0f);
        }
        this.renderAttributes.setDepthBufferEnable(true);
        this.renderAttributes.setDepthBufferWriteEnable(true);
        this.renderAttributes.setIgnoreVertexColors(true);
        this.renderAttributes.setCapability(5);
        this.renderAttributes.setCapability(6);
        this.polygonAttributes = new PolygonAttributes();
        this.polygonAttributes.setBackFaceNormalFlip(false);
        this.polygonAttributes.setCullFace(0);
        this.polygonAttributes.setPolygonMode(2);
        this.textureAttributes = new TextureAttributes();
        this.textureAttributes.setTextureMode(5);
        this.textureAttributes.setPerspectiveCorrectionMode(0);
        if (this.hasAlpha) {
            this.transparencyAttributes = new TransparencyAttributes(2, 1.0f);
            this.textureAttributes.setTextureBlendColor(new Color4f(0.0f, 0.0f, 0.0f, 1.0f));
        }
        object = OverlayUtilities.subdivide(this.overlayBounds.getSize(), this.minDivSize, 256);
        this.subOverlay = new SubOverlay[object.size()];
        int n2 = object.size();
        int n3 = 0;
        while (n3 < n2) {
            Rectangle rectangle2 = (Rectangle)object.get(n3);
            this.subOverlay[n3] = new SubOverlay(rectangle2, n, this.hasAlpha, this.polygonAttributes, this.renderAttributes, this.textureAttributes, this.transparencyAttributes);
            this.consoleTG.addChild((Node)this.subOverlay[n3].getShape());
            ++n3;
        }
        this.dirtyCheck[0] = true;
        this.dirtyCheck[1] = true;
        this.dirtyCheck[2] = true;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
        updateManager.updateRequested();
    }

    public void setOffset(Dimension dimension) {
        this.setOffset(dimension.width, dimension.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(int n, int n2) {
        if (this.offset.width != n || this.offset.height != n2) {
            Dimension dimension = this.offset;
            synchronized (dimension) {
                this.offset.width = n;
                this.offset.height = n2;
                this.dirty(1);
            }
        }
    }

    public void setRelativePosition(int[] nArray) {
        this.setRelativePosition(this.relativePosition[0], this.relativePosition[1]);
    }

    public void setRelativePosition(int n, int n2) {
        if (this.relativePosition[0] != n || this.relativePosition[1] != n2) {
            this.relativePosition[0] = n;
            this.relativePosition[1] = n2;
            this.dirty(1);
        }
    }

    public BranchGroup getRoot() {
        return this.consoleBG;
    }

    public void setAntialiased(boolean bl) {
        if (this.antialiased != bl) {
            this.antialiased = bl;
            this.repaint();
        }
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public Canvas3D getCanvas() {
        return this.canvas3D;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.dirty(0);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        if (this.overlayBounds.width == 0 || this.overlayBounds.height == 0) {
            return;
        }
        this.updateBackgroundColor();
    }

    public BufferedImage getBackgroundImage() {
        if (this.backgroundImage == null) {
            this.backgroundImage = OverlayUtilities.createBufferedImage(this.overlayBounds.getSize(), this.hasAlpha);
        }
        return this.backgroundImage;
    }

    public void setBackgroundImage(BufferedImage bufferedImage) {
        if (this.backgroundImage != bufferedImage) {
            this.backgroundImage = bufferedImage;
            this.repaint();
        }
    }

    public void setBackgroundMode(int n) {
        if (this.backgroundMode != n) {
            this.backgroundMode = n;
            this.repaint();
        }
    }

    public void update() {
        if (this.dirtyCheck[3]) {
            this.syncSize();
        }
        if (this.dirtyCheck[1]) {
            this.syncPosition();
        }
        if (this.dirtyCheck[0]) {
            this.syncVisible();
        }
        if (this.dirtyCheck[2]) {
            this.syncActiveBuffer();
        }
    }

    public Rectangle getBounds() {
        return this.overlayBounds;
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.fixedSize) {
            this.dirty(1);
        } else {
            this.dirty(3);
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.dirty(1);
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void initialize() {
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseManager.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseManager.removeMouseListener(mouseListener);
    }

    protected void dirty(int n) {
        this.dirtyCheck[n] = true;
        if (this.updateManager != null) {
            this.updateManager.updateRequested();
        } else {
            System.err.println("Null update manager in: " + this);
        }
    }

    protected void setActiveBuffer(int n) {
        this.activeBuffer = n;
        this.dirty(2);
    }

    protected Graphics2D getGraphics() {
        if (this.backgroundMode == 1 && this.backgroundImage != null) {
            this.canvas.setData(this.backgroundImage.getRaster());
        }
        Graphics2D graphics2D = (Graphics2D)this.canvas.getGraphics();
        if (this.antialiased) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return graphics2D;
    }

    public void paint(Graphics2D graphics2D) {
    }

    public void repaint() {
        if (!this.painting) {
            this.painting = true;
            Graphics2D graphics2D = this.getGraphics();
            this.paint(graphics2D);
            graphics2D.dispose();
            this.updateBuffer(this.canvas, -1);
            this.setActiveBuffer(-1);
            this.painting = false;
        } else {
            System.err.println("Skipped paint in: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBuffer(BufferedImage bufferedImage, int n) {
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (subOverlayArray) {
            int n2 = this.subOverlay.length - 1;
            while (n2 >= 0) {
                this.subOverlay[n2].updateBuffer(bufferedImage, n);
                --n2;
            }
        }
    }

    private void updateBackgroundColor() {
        int[] nArray = new int[this.overlayBounds.width * this.overlayBounds.height];
        int n = this.backgroundColor.getRGB();
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            nArray[n2] = n;
            --n2;
        }
        this.getBackgroundImage().setRGB(0, 0, this.overlayBounds.width, this.overlayBounds.height, nArray, 0, this.overlayBounds.width);
        this.repaint();
    }

    private void syncVisible() {
        this.renderAttributes.setVisible(this.visible);
        this.dirtyCheck[0] = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncActiveBuffer() {
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (subOverlayArray) {
            int n = this.subOverlay.length - 1;
            while (n >= 0) {
                this.subOverlay[n].setActiveBufferIndex(this.activeBuffer);
                --n;
            }
            this.dirtyCheck[2] = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncPosition() {
        Rectangle rectangle = this.overlayBounds;
        synchronized (rectangle) {
            Dimension dimension = this.canvas3D.getSize();
            if (dimension.width == 0 || dimension.height == 0) {
                return;
            }
            if (this.canvas == null) {
                this.canvas = OverlayUtilities.createBufferedImage(this.overlayBounds.getSize(), this.hasAlpha);
            }
            if (this.backgroundColor != null) {
                this.updateBackgroundColor();
            }
            OverlayUtilities.repositonBounds(this.overlayBounds, this.relativePosition, dimension, this.offset);
            double d = this.canvas3D.getView().getFieldOfView();
            double d2 = (double)4.2f * Math.tan(d / 2.0);
            double d3 = d2 / dimension.getWidth();
            double d4 = dimension.getHeight() * d3;
            Point point = new Point(this.overlayBounds.x, dimension.height - this.overlayBounds.height - this.overlayBounds.y);
            Transform3D transform3D = new Transform3D();
            Vector3d vector3d = new Vector3d(-d2 / 2.0 + point.getX() * d3, -d4 / 2.0 + point.getY() * d3, (double)-2.1f);
            transform3D.setTranslation(vector3d);
            transform3D.setScale(d3);
            this.consoleTG.setTransform(transform3D);
            this.dirtyCheck[1] = false;
        }
    }

    private void syncSize() {
        if (!this.fixedSize) {
            this.overlayBounds = this.canvas3D.getBounds();
        }
        if (this.overlayBounds.width != 0 && this.overlayBounds.height != 0) {
            this.overlayTexGrp = new BranchGroup();
            this.overlayTexGrp.setCapability(17);
            this.consoleTG = new TransformGroup();
            this.consoleTG.setCapability(18);
            this.overlayTexGrp.addChild((Node)this.consoleTG);
            List list = OverlayUtilities.subdivide(this.overlayBounds.getSize(), this.minDivSize, 256);
            this.subOverlay = new SubOverlay[list.size()];
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Rectangle rectangle = (Rectangle)list.get(n2);
                this.subOverlay[n2] = new SubOverlay(rectangle, this.numBuffers, this.hasAlpha, this.polygonAttributes, this.renderAttributes, this.textureAttributes, this.transparencyAttributes);
                this.consoleTG.addChild((Node)this.subOverlay[n2].getShape());
                ++n2;
            }
            this.consoleBG.setChild((Node)this.overlayTexGrp, 0);
        } else {
            this.overlayTexGrp = null;
            this.consoleTG = null;
            this.subOverlay = new SubOverlay[0];
            this.consoleBG.setChild(null, 0);
        }
        this.dirtyCheck[3] = false;
        this.syncPosition();
    }
}

