/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.overlay;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import org.j3d.geom.overlay.OverlayUtilities;

class SubOverlay {
    static final int NEXT_BUFFER = -1;
    private BufferedImage[] buffer;
    private ImageComponent2D[] bufferHolder;
    private int numBuffers;
    private int activeBufferIndex = 0;
    private Texture2D texture;
    private Shape3D shape;
    private Rectangle space;
    private int[] transferBuffer;

    SubOverlay(Rectangle rectangle) {
        this(rectangle, 2, false, null, null, null, null);
    }

    SubOverlay(Rectangle rectangle, int n) {
        this(rectangle, n, false, null, null, null, null);
    }

    SubOverlay(Rectangle rectangle, boolean bl) {
        this(rectangle, 2, bl, null, null, null, null);
    }

    SubOverlay(Rectangle rectangle, int n, boolean bl) {
        this(rectangle, n, bl, null, null, null, null);
    }

    SubOverlay(Rectangle rectangle, int n, boolean bl, PolygonAttributes polygonAttributes, RenderingAttributes renderingAttributes, TextureAttributes textureAttributes, TransparencyAttributes transparencyAttributes) {
        this.space = rectangle;
        this.numBuffers = n;
        this.buffer = new BufferedImage[n];
        this.bufferHolder = new ImageComponent2D[n];
        this.transferBuffer = new int[rectangle.width];
        int n2 = bl ? 2 : 1;
        Dimension dimension = new Dimension(OverlayUtilities.smallestPower(rectangle.width), OverlayUtilities.smallestPower(rectangle.height));
        int n3 = n - 1;
        while (n3 >= 0) {
            this.buffer[n3] = OverlayUtilities.createBufferedImage(dimension, bl);
            this.bufferHolder[n3] = new ImageComponent2D(n2, this.buffer[n3], true, true);
            --n3;
        }
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setTextureAttributes(textureAttributes);
        appearance.setTransparencyAttributes(transparencyAttributes);
        Material material = new Material();
        material.setLightingEnable(false);
        appearance.setMaterial(material);
        this.texture = new Texture2D(1, bl ? 6 : 5, dimension.width, dimension.height);
        this.texture.setBoundaryModeS(3);
        this.texture.setBoundaryModeT(3);
        this.texture.setMagFilter(1);
        this.texture.setMinFilter(0);
        this.texture.setImage(0, (ImageComponent)this.bufferHolder[this.activeBufferIndex]);
        this.texture.setCapability(7);
        appearance.setTexture((Texture)this.texture);
        this.shape = this.buildShape(appearance, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBuffer(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (n == -1) {
            n = this.getNextBufferIndex();
        }
        int n4 = n3 - this.space.y - this.space.height;
        BufferedImage bufferedImage2 = this.buffer[n];
        synchronized (bufferedImage2) {
            int n5 = 0;
            while (n5 < this.space.height) {
                bufferedImage.getRGB(this.space.x, n4 + n5, this.transferBuffer.length, 1, this.transferBuffer, 0, n2);
                this.buffer[n].setRGB(0, this.space.height - n5 - 1, this.transferBuffer.length, 1, this.transferBuffer, 0, n2);
                ++n5;
            }
        }
    }

    int getNextBufferIndex() {
        return (this.activeBufferIndex + 1) % this.numBuffers;
    }

    void setActiveBufferIndex(int n) {
        if (n == -1) {
            n = this.getNextBufferIndex();
        }
        if (this.activeBufferIndex != n) {
            this.activeBufferIndex = n;
            this.texture.setImage(0, (ImageComponent)this.bufferHolder[this.activeBufferIndex]);
        }
    }

    Shape3D getShape() {
        return this.shape;
    }

    private Shape3D buildShape(Appearance appearance, Rectangle rectangle) {
        int n = 33;
        QuadArray quadArray = new QuadArray(4, n);
        float[] fArray = new float[]{rectangle.x + rectangle.width, rectangle.y, 0.0f, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0.0f, rectangle.x, rectangle.y + rectangle.height, 0.0f, rectangle.x, rectangle.y, 0.0f};
        quadArray.setCoordinates(0, fArray);
        float f = rectangle.width / this.texture.getWidth();
        float f2 = rectangle.height / this.texture.getHeight();
        float[] fArray2 = new float[]{f, 0.0f, f, f2, 0.0f, f2, 0.0f, 0.0f};
        quadArray.setTextureCoordinates(0, 0, fArray2);
        Shape3D shape3D = new Shape3D();
        shape3D.setGeometry((Geometry)quadArray);
        shape3D.setAppearance(appearance);
        return shape3D;
    }
}

