/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.Map;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Shape3D;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleInitializer;
import org.j3d.geom.particle.ParticleSystem;

public abstract class ByRefParticleSystem
extends ParticleSystem
implements GeometryUpdater {
    protected GeometryArray geometryArray;
    protected double[] positionRefArray;
    protected float[] textureCoordRefArray;
    protected float[] colorRefArray;
    protected float[] normalRefArray;
    protected Shape3D shape = new OrientedShape3D();

    public ByRefParticleSystem(int n, ParticleInitializer particleInitializer, int n2, Map map) {
        super(n, map);
        this.initializeArrays(n2);
        this.createParticles(particleInitializer, n2);
        this.geometryArray = this.createGeometryArray();
        this.geometryArray.setCapability(19);
        this.shape.setGeometry((Geometry)this.geometryArray);
        this.shape.setAppearance(this.createAppearance());
        this.shape.setCollidable(false);
        this.shape.setPickable(false);
        this.shape.setBoundsAutoCompute(false);
    }

    public Node getNode() {
        return this.shape;
    }

    public abstract GeometryArray createGeometryArray();

    public abstract Appearance createAppearance();

    protected abstract int getVertexCount();

    public boolean update() {
        this.geometryArray.updateData((GeometryUpdater)this);
        return this.running;
    }

    public void updateData(Geometry geometry) {
        GeometryArray geometryArray = (GeometryArray)geometry;
        int n = this.particleCount - 1;
        while (n >= 0) {
            Particle particle = (Particle)this.particles.get(n);
            particle.incAge();
            this.running |= this.updateParticle(n, particle);
            --n;
        }
        geometryArray.setCoordRefDouble(this.positionRefArray);
        geometryArray.setColorRefFloat(this.colorRefArray);
        geometryArray.setNormalRefFloat(this.normalRefArray);
        geometryArray.setTexCoordRefFloat(0, this.textureCoordRefArray);
    }

    protected synchronized void initializeArrays(int n) {
        if (this.positionRefArray == null) {
            int n2 = this.getVertexCount();
            int n3 = n * n2 * 3;
            int n4 = n * n2 * 4;
            int n5 = n * n2 * 3;
            int n6 = n * n2 * 2;
            this.positionRefArray = new double[n3];
            this.colorRefArray = new float[n4];
            this.normalRefArray = new float[n5];
            this.textureCoordRefArray = new float[n6];
        }
    }
}

