/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import org.j3d.geom.particle.ParticleSystem;

public class ParticleSystemManager
extends Behavior {
    private List particleSystems = new ArrayList();
    private WakeupCondition wakeupCondition;
    private long startTime = 0L;
    private long numUpdates = 0L;

    public ParticleSystemManager(WakeupCondition wakeupCondition, Map map) {
        this.wakeupCondition = wakeupCondition;
    }

    public void initialize() {
        this.wakeupOn(this.wakeupCondition);
    }

    public void processStimulus(Enumeration enumeration) {
        this.update();
        this.wakeupOn(this.wakeupCondition);
    }

    public void update() {
        int n = this.particleSystems.size() - 1;
        while (n >= 0) {
            ParticleSystem particleSystem = (ParticleSystem)this.particleSystems.get(n);
            if (particleSystem != null && !particleSystem.update()) {
                System.out.println("Removing ParticleSystem: " + particleSystem);
                this.particleSystems.remove(n);
            }
            --n;
        }
        if (this.numUpdates == 1000L) {
            if (this.startTime > 0L) {
                System.out.println("FPS: " + 1000.0f * (float)this.numUpdates / (float)(System.currentTimeMillis() - this.startTime));
            }
            this.startTime = System.currentTimeMillis();
            this.numUpdates = 0L;
        }
        ++this.numUpdates;
    }

    public void addParticleSystem(ParticleSystem particleSystem) {
        this.particleSystems.add(particleSystem);
    }

    public void removeParticleSystem(ParticleSystem particleSystem) {
        this.particleSystems.remove(particleSystem);
    }
}

