/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.Map;
import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color4f;
import org.j3d.geom.particle.ByRefParticleSystem;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleInitializer;
import org.j3d.geom.particle.TriangleArrayByRefParticle;

public class TriangleArrayByRefParticleSystem
extends ByRefParticleSystem {
    public static final int TRIANGLE_ARRAY_BYREF_PARTICLE_SYSTEM = 1;
    private static PolygonAttributes polygonAttributes = new PolygonAttributes(2, 0, 0.0f);
    private static TransparencyAttributes transparencyAttributes = new TransparencyAttributes(1, 0.0f);
    private static TextureAttributes textureAttributes = new TextureAttributes(5, new Transform3D(), new Color4f(), 0);

    public TriangleArrayByRefParticleSystem(int n, ParticleInitializer particleInitializer, Map map) {
        super(1, particleInitializer, n, map);
    }

    public GeometryArray createGeometryArray() {
        TriangleArray triangleArray = new TriangleArray(this.particleCount * 6, 173);
        return triangleArray;
    }

    public Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setTextureAttributes(textureAttributes);
        Object v = this.environment.get("texture");
        Texture texture = null;
        if (!(v instanceof String) && v instanceof Texture) {
            texture = (Texture)v;
        }
        appearance.setTexture(texture);
        return appearance;
    }

    public Particle createParticle(int n) {
        return new TriangleArrayByRefParticle(this.shape, n, this.positionRefArray, this.colorRefArray, this.textureCoordRefArray, this.normalRefArray);
    }

    protected int getVertexCount() {
        return 6;
    }
}

