/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.particle.MovementFunction;
import org.j3d.geom.particle.Particle;

public class WindMovementFunction
implements MovementFunction {
    private static final int MAX_AGE = 300;
    private Point3d windStart = new Point3d(0.0, -1000.0, 0.0);
    private Point3d windEnd = new Point3d(0.0, 1000.0, 0.0);
    private Vector3d ab;
    private Vector3d ap = new Vector3d();
    private Vector3d crossAbAp = new Vector3d();
    private double abLength;
    private double attenuationStart = 0.01;
    private double attenuationEnd = 10.0;
    private Vector3d forcePerSquareMeter = new Vector3d(0.0, 0.001, 0.0);
    private Vector3d currentForcePerSquareMeter = new Vector3d();
    private double gustiness = 0.6;
    private double swirlinessX = 1.0E-4;
    private double swirlinessY = 1.0E-4;
    private double swirlinessZ = 1.0E-4;

    public WindMovementFunction() {
        this.ab = new Vector3d(this.windEnd.x - this.windStart.x, this.windEnd.y - this.windStart.y, this.windEnd.z - this.windStart.z);
        this.abLength = this.ab.length();
    }

    public boolean apply(Particle particle) {
        this.currentForcePerSquareMeter.x = this.getRandomNumber(this.forcePerSquareMeter.x, this.forcePerSquareMeter.x * this.gustiness);
        this.currentForcePerSquareMeter.y = this.getRandomNumber(this.forcePerSquareMeter.y, this.forcePerSquareMeter.y * this.gustiness);
        this.currentForcePerSquareMeter.z = this.getRandomNumber(this.forcePerSquareMeter.z, this.forcePerSquareMeter.z * this.gustiness);
        particle.getPosition((Tuple3d)this.ap);
        this.ap.sub((Tuple3d)this.windStart);
        this.crossAbAp.cross(this.ab, this.ap);
        double d = this.crossAbAp.length() / this.abLength;
        if (d > this.attenuationStart) {
            if (d <= this.attenuationEnd) {
                this.currentForcePerSquareMeter.scale((d - this.attenuationStart) / (this.attenuationEnd - this.attenuationStart));
            } else {
                this.currentForcePerSquareMeter.set(0.0, 0.0, 0.0);
            }
        }
        if (d < this.attenuationEnd) {
            this.currentForcePerSquareMeter.x += this.getRandomNumber(0.0, this.swirlinessX);
            this.currentForcePerSquareMeter.y += this.getRandomNumber(0.0, this.swirlinessY);
            this.currentForcePerSquareMeter.z += this.getRandomNumber(0.0, this.swirlinessZ);
            this.currentForcePerSquareMeter.scale(particle.surfaceArea);
            particle.resultantForce.add((Tuple3d)this.currentForcePerSquareMeter);
        }
        particle.setAlpha(particle.getCycleAge() / 300);
        return true;
    }

    private double getRandomNumber(double d, double d2) {
        return d + (double)((float)Math.random()) * d2 * 2.0 - d2;
    }
}

