/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.terrain;

import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.util.interpolator.ColorInterpolator;

public class ColorRampGenerator {
    private static final String LENGTH_MSG = "Ramp and height arrays not same length";
    private ColorInterpolator interpolator;
    private boolean hasAlpha;

    public ColorRampGenerator() {
        this.hasAlpha = false;
        this.interpolator = new ColorInterpolator(2);
        this.interpolator.addRGBKeyFrame(0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.interpolator.addRGBKeyFrame(0.5f, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    public ColorRampGenerator(float[] fArray, Color3f[] color3fArray) {
        this.setColorRamp(fArray, color3fArray);
    }

    public ColorRampGenerator(float[] fArray, Color4f[] color4fArray) {
        this.setColorRamp(fArray, color4fArray);
    }

    public void setColorRamp(float[] fArray, Color3f[] color3fArray) {
        if (fArray.length != color3fArray.length) {
            throw new IllegalArgumentException(LENGTH_MSG);
        }
        this.hasAlpha = false;
        this.interpolator = new ColorInterpolator(fArray.length);
        int n = 0;
        while (n < fArray.length) {
            this.interpolator.addRGBKeyFrame(fArray[n], color3fArray[n].x, color3fArray[n].y, color3fArray[n].z, 0.0f);
            ++n;
        }
    }

    public void setColorRamp(float[] fArray, Color4f[] color4fArray) {
        if (fArray.length != color4fArray.length) {
            throw new IllegalArgumentException(LENGTH_MSG);
        }
        this.hasAlpha = true;
        this.interpolator = new ColorInterpolator(fArray.length);
        int n = 0;
        while (n < fArray.length) {
            this.interpolator.addRGBKeyFrame(fArray[n], color4fArray[n].x, color4fArray[n].y, color4fArray[n].z, color4fArray[n].w);
            ++n;
        }
    }

    public void generate(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.vertexCount == 0) {
            return;
        }
        int n = geometryData.vertexCount * 3;
        if (this.hasAlpha) {
            n += geometryData.vertexCount;
        }
        if (geometryData.colors != null && geometryData.colors.length < n) {
            throw new InvalidArraySizeException("Color array", geometryData.colors.length, n);
        }
        if (geometryData.colors == null) {
            geometryData.colors = new float[n];
        }
        float[] fArray = geometryData.coordinates;
        float[] fArray2 = geometryData.colors;
        if (this.hasAlpha) {
            int n2 = n - 1;
            int n3 = n * 3 / 4 - 2;
            while (n3 > 0) {
                float[] fArray3 = this.interpolator.floatRGBValue(fArray[n3]);
                fArray2[n2--] = fArray3[3];
                fArray2[n2--] = fArray3[2];
                fArray2[n2--] = fArray3[1];
                fArray2[n2--] = fArray3[0];
                n3 -= 3;
            }
        } else {
            int n4 = n - 2;
            while (n4 > 0) {
                float[] fArray4 = this.interpolator.floatRGBValue(fArray[n4]);
                fArray2[n4 + 1] = fArray4[2];
                fArray2[n4] = fArray4[1];
                fArray2[n4 - 1] = fArray4[0];
                n4 -= 3;
            }
        }
    }
}

