/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.terrain;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public class HeightDataCreator {
    private static final float MIN_HEIGHT = 0.0f;
    private static final float MAX_HEIGHT = 1.0f;
    private static final float DEFAULT_SPACING = 1.0f;
    private float minHeight;
    private float maxHeight;

    public HeightDataCreator() {
        this(0.0f, 1.0f);
    }

    public HeightDataCreator(float f, float f2) {
        if (f2 < f) {
            throw new IllegalArgumentException("Max < min");
        }
        this.minHeight = f;
        this.maxHeight = f2;
    }

    public void setHeightRange(float f, float f2) {
        if (f2 < f) {
            throw new IllegalArgumentException("Max < min");
        }
        this.minHeight = f;
        this.maxHeight = f2;
    }

    public float[][] createHeightField(BufferedImage bufferedImage) {
        Object object;
        Raster raster = bufferedImage.getData();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n = colorModel.getNumComponents();
        if (n > 1) {
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
            object = colorConvertOp.filter(bufferedImage, null);
            raster = ((BufferedImage)object).getData();
        }
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        object = new float[n2][n3];
        int[] nArray = new int[n2];
        float f = this.maxHeight - this.minHeight;
        int n4 = 0;
        while (n4 < n3) {
            raster.getSamples(0, n4, n2, 1, 0, nArray);
            int n5 = 0;
            while (n5 < n2) {
                object[n4][n5] = (float)nArray[n5] * f / 255.0f;
                ++n5;
            }
            ++n4;
        }
        return object;
    }
}

