/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Triangulator;
import java.net.URL;
import java.util.Stack;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import org.j3d.loaders.ac3d.models.Ac3dMaterial;
import org.j3d.loaders.ac3d.models.Ac3dObject;
import org.j3d.loaders.ac3d.models.Ac3dSurface;
import org.j3d.loaders.ac3d.parser.exceptions.AC3DParseException;
import org.j3d.loaders.ac3d.parser.handlers.Ac3dTokenHandlerBase;
import org.j3d.loaders.ac3d.util.TextureLoaderHelper;

public class LoaderTokenHandler
extends Ac3dTokenHandlerBase {
    private SceneBase scene = null;
    private BranchGroup world;
    private BranchGroup currentGroup;
    private Stack callStack;
    private int kidsLeft;
    private static final double FLAT_CREASE_ANGLE = 0.0;
    private static final double SMOOTH_CREASE_ANGLE = 3.142857142857143;
    private boolean sourceIsFile = true;

    public void token_kids(String[] stringArray) throws AC3DParseException {
        super.token_kids(stringArray);
        Ac3dObject ac3dObject = (Ac3dObject)this.displayList.elementAt(this.displayList.size() - 1);
        if (ac3dObject.getType().equals("world")) {
            this.debug("OBJECT: Creating \"WORLD\" BranchGroup.");
            this.currentGroup = this.world;
            this.kidsLeft = ac3dObject.getNumKids();
        }
        if (ac3dObject.getType().equals("poly") || ac3dObject.getType().equals("group")) {
            BranchGroup branchGroup;
            if (ac3dObject.getType().equals("poly")) {
                this.debug("OBJECT: Adding \"POLY\" to local BranchGroup.");
                branchGroup = this.buildPoly(ac3dObject, this.currentGroup);
            } else {
                this.debug("OBJECT: Adding \"GROUP\" to local BranchGroup.");
                branchGroup = LoaderTokenHandler.buildGroup(ac3dObject, this.currentGroup);
            }
            --this.kidsLeft;
            this.callStack.push(new CallStackPlaceholder(this.currentGroup, this.kidsLeft));
            this.scene.addNamedObject(ac3dObject.getName(), (Object)branchGroup);
            this.currentGroup = branchGroup;
            this.kidsLeft = ac3dObject.getNumKids();
        }
        while (this.kidsLeft == 0 && this.callStack.size() > 0) {
            CallStackPlaceholder callStackPlaceholder = (CallStackPlaceholder)this.callStack.pop();
            this.kidsLeft = callStackPlaceholder.getKidsLeft();
            this.currentGroup = callStackPlaceholder.getBranchGroup();
        }
    }

    private final BranchGroup buildPoly(Ac3dObject ac3dObject, BranchGroup branchGroup) {
        Texture2D texture2D = null;
        if (!ac3dObject.getTexture().equals("")) {
            texture2D = new TextureLoaderHelper().loadTexture(ac3dObject.getTexture());
        }
        BranchGroup branchGroup2 = LoaderTokenHandler.buildGroup(ac3dObject, branchGroup);
        int n = 0;
        while (n < ac3dObject.getNumsurf()) {
            Ac3dSurface ac3dSurface = ac3dObject.getSurface(n);
            Shape3D shape3D = new Shape3D();
            Appearance appearance = LoaderTokenHandler.buildAppearance(ac3dSurface, (Ac3dMaterial)this.materials.elementAt(ac3dSurface.getMat()));
            if (texture2D != null) {
                appearance.setTexture((Texture)texture2D);
            }
            shape3D.setAppearance(appearance);
            if (ac3dSurface.checkFlag(1) || ac3dSurface.checkFlag(2)) {
                shape3D.setGeometry(LoaderTokenHandler.buildLineGeometry(ac3dSurface, ac3dObject));
            } else {
                shape3D.setGeometry(LoaderTokenHandler.buildSurfaceGeometry(ac3dSurface, ac3dObject, texture2D != null));
            }
            branchGroup2.addChild((Node)shape3D);
            ++n;
        }
        return branchGroup2;
    }

    private static final BranchGroup buildGroup(Ac3dObject ac3dObject, BranchGroup branchGroup) {
        BranchGroup branchGroup2 = new BranchGroup();
        Transform3D transform3D = new Transform3D();
        Transform3D transform3D2 = new Transform3D();
        transform3D.setRotation(new Matrix3f(ac3dObject.getRot()));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transform3D2.set(new Vector3f(ac3dObject.getLoc()));
        TransformGroup transformGroup2 = new TransformGroup(transform3D2);
        branchGroup.addChild((Node)transformGroup2);
        transformGroup2.addChild((Node)transformGroup);
        transformGroup.addChild((Node)branchGroup2);
        return branchGroup2;
    }

    private static final Geometry buildSurfaceGeometry(Ac3dSurface ac3dSurface, Ac3dObject ac3dObject, boolean bl) {
        int[] nArray = ac3dSurface.getVerticiesIndex();
        float[] fArray = new float[nArray.length * 3];
        float[] fArray2 = ac3dObject.getVerticies();
        GeometryInfo geometryInfo = new GeometryInfo(5);
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < 3) {
                fArray[n * 3 + n2] = fArray2[nArray[n] * 3 + n2];
                ++n2;
            }
            ++n;
        }
        geometryInfo.setCoordinates(fArray);
        if (bl) {
            geometryInfo.setTextureCoordinates2(ac3dSurface.getTextureCoordinates());
        }
        geometryInfo.setStripCounts(new int[]{nArray.length});
        new Triangulator().triangulate(geometryInfo);
        if (ac3dSurface.checkFlag(16)) {
            new NormalGenerator(3.142857142857143).generateNormals(geometryInfo);
        } else {
            new NormalGenerator(0.0).generateNormals(geometryInfo);
        }
        return geometryInfo.getGeometryArray();
    }

    private static final Geometry buildLineGeometry(Ac3dSurface ac3dSurface, Ac3dObject ac3dObject) {
        int n;
        int[] nArray = ac3dSurface.getVerticiesIndex();
        float[] fArray = ac3dObject.getVerticies();
        int n2 = ac3dSurface.checkFlag(1) ? nArray.length : nArray.length - 1;
        float[] fArray2 = new float[n2 * 6];
        LineArray lineArray = new LineArray(n2 * 2, 1);
        int n3 = 0;
        while (n3 < nArray.length - 1) {
            n = 0;
            while (n < 3) {
                fArray2[2 * n3 * 3 + n] = fArray[nArray[n3] * 3 + n];
                fArray2[(2 * n3 + 1) * 3 + n] = fArray[nArray[n3 + 1] * 3 + n];
                ++n;
            }
            ++n3;
        }
        if (ac3dSurface.checkFlag(1)) {
            n = 0;
            while (n < 3) {
                fArray2[6 * n2 - (6 - n)] = fArray2[6 * n2 - (9 - n)];
                fArray2[6 * n2 - (3 - n)] = fArray2[n];
                ++n;
            }
        }
        lineArray.setCoordinates(0, fArray2);
        return lineArray;
    }

    private static final Appearance buildAppearance(Ac3dSurface ac3dSurface, Ac3dMaterial ac3dMaterial) {
        Appearance appearance = new Appearance();
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        appearance.setMaterial(LoaderTokenHandler.buildMaterial(ac3dMaterial));
        if (ac3dSurface.checkFlag(1) || ac3dSurface.checkFlag(2)) {
            polygonAttributes.setPolygonMode(1);
        }
        if (ac3dSurface.checkFlag(32)) {
            polygonAttributes.setCullFace(0);
        }
        coloringAttributes.setShadeModel(1);
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setColoringAttributes(coloringAttributes);
        return appearance;
    }

    private static final Material buildMaterial(Ac3dMaterial ac3dMaterial) {
        Material material = new Material();
        material.setDiffuseColor(new Color3f(ac3dMaterial.getRgb()));
        material.setAmbientColor(new Color3f(ac3dMaterial.getAmb()));
        material.setEmissiveColor(new Color3f(ac3dMaterial.getEmis()));
        material.setSpecularColor(new Color3f(ac3dMaterial.getSpec()));
        material.setShininess((float)ac3dMaterial.getShi());
        return material;
    }

    public void reset() {
        super.reset();
        this.scene = new SceneBase();
        this.world = new BranchGroup();
        this.currentGroup = null;
        this.scene.setSceneGroup(this.world);
        this.kidsLeft = 0;
        this.callStack = new Stack();
        this.sourceIsFile = true;
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setBasePath(String string) {
        this.sourceIsFile = true;
    }

    public void setBaseUrl(URL uRL) {
        this.sourceIsFile = false;
    }

    private class CallStackPlaceholder {
        private BranchGroup branchGroup;
        private int kidsLeft;

        private CallStackPlaceholder(BranchGroup branchGroup, int n) {
            this.branchGroup = branchGroup;
            this.kidsLeft = n;
        }

        private BranchGroup getBranchGroup() {
            return this.branchGroup;
        }

        private int getKidsLeft() {
            return this.kidsLeft;
        }
    }
}

