/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.j3d.loaders.ac3d.parser.OutputHandler;
import org.j3d.loaders.ac3d.parser.handlers.ConsoleOutputHandler;

public abstract class TokenHandler {
    private static Class[] TOKEN_ARGS_LIST = new Class[1];
    private boolean shouldDebug;
    private boolean shouldError;
    private OutputHandler debugHandler;
    private OutputHandler errorHandler;
    private int version;
    static /* synthetic */ Class array$Ljava$lang$String;

    public TokenHandler() {
        this.setVersion(65535);
        this.shouldDebug = false;
        this.shouldError = true;
        this.errorHandler = new ConsoleOutputHandler();
    }

    public abstract void reset();

    public final void handle(String[] stringArray) {
        try {
            Method method = this.getClass().getMethod("token_" + stringArray[0], TOKEN_ARGS_LIST);
            Object[] objectArray = new Object[]{stringArray};
            method.invoke((Object)this, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.debug("UNKNOWN TOKEN: " + stringArray[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            this.error(throwable, "Invokation problem encountered on handle.");
        }
        catch (Exception exception) {
            this.error(exception, "Unanticipated exception when trying to handle tokens.");
        }
    }

    public final void setShouldDebug(boolean bl) {
        this.shouldDebug = bl;
    }

    public final void setShouldError(boolean bl) {
        this.shouldError = bl;
    }

    public final void setDebugHandler(OutputHandler outputHandler) {
        if (outputHandler != null) {
            this.shouldDebug = true;
            this.debugHandler = outputHandler;
        } else {
            this.shouldDebug = false;
        }
    }

    public final void setErrorHandler(OutputHandler outputHandler) {
        if (outputHandler != null) {
            this.shouldError = true;
            this.errorHandler = outputHandler;
        } else {
            this.shouldError = false;
        }
    }

    protected final void debug(String string) {
        if (this.shouldDebug && this.debugHandler != null) {
            this.debugHandler.println(string);
        }
    }

    protected final void error(Throwable throwable, String string) {
        if (this.shouldError && this.errorHandler != null) {
            this.errorHandler.println(string);
            this.errorHandler.println(throwable.getMessage());
        }
    }

    protected final void setVersion(int n) {
        this.version = n;
    }

    public final int getVersion() {
        return this.version;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TokenHandler.TOKEN_ARGS_LIST[0] = array$Ljava$lang$String == null ? (array$Ljava$lang$String = TokenHandler.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
    }
}

