/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.dem;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.j3d.loaders.dem.DEMTypeARecord;
import org.j3d.loaders.dem.DEMTypeBRecord;
import org.j3d.loaders.dem.DEMTypeCRecord;
import org.j3d.util.CharHashMap;

public class DEMParser {
    private static CharHashMap processCodes = new CharHashMap(7);
    private byte[] buffer = new byte[40];
    private BufferedInputStream input;
    private DEMTypeARecord header;
    private DEMTypeBRecord[] heights;
    private DEMTypeCRecord statistics;
    private boolean dataReady = false;
    private boolean hasTypeC;

    public DEMParser() {
    }

    public DEMParser(InputStream inputStream) {
        this();
        this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public void reset(InputStream inputStream) {
        this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.dataReady = false;
        this.header = null;
        this.heights = null;
        this.statistics = null;
        this.hasTypeC = false;
    }

    public DEMTypeARecord getTypeARecord() {
        return this.header;
    }

    public DEMTypeBRecord[] getTypeBRecords() {
        return this.heights;
    }

    public DEMTypeCRecord getTypeCRecord() {
        return this.statistics;
    }

    public float[][] parse(boolean bl) throws IOException {
        if (this.dataReady) {
            throw new IOException("Data has already been read from this stream");
        }
        this.parseARecord();
        this.parseBRecords();
        this.parseCRecord();
        float[][] fArray = null;
        if (bl) {
            // empty if block
        }
        return fArray;
    }

    private void parseARecord() throws IOException {
        this.header = new DEMTypeARecord();
        this.input.read(this.buffer, 0, 40);
        this.header.filename = new String(this.buffer).trim();
        this.input.read(this.buffer, 0, 40);
        this.header.freeFormatText = new String(this.buffer).trim();
        this.input.skip(28L);
        this.readGeoCoords();
        char c = (char)(this.input.read() & 0xFF);
        this.header.processCode = (Integer)processCodes.get(c);
        this.input.skip(1L);
        this.input.read(this.buffer, 0, 3);
        this.header.sectionIndicator = new String(this.buffer, 0, 3);
        this.input.read(this.buffer, 0, 4);
        this.header.originCode = new String(this.buffer, 0, 4);
    }

    private void parseBRecords() throws IOException {
    }

    private void parseCRecord() throws IOException {
    }

    private void readGeoCoords() throws IOException {
        this.input.read(this.buffer, 0, 4);
        int n = Integer.parseInt(new String(this.buffer, 0, 4));
        this.input.read(this.buffer, 0, 2);
        int n2 = Integer.parseInt(new String(this.buffer, 0, 2));
        this.input.read(this.buffer, 0, 7);
        float f = Float.parseFloat(new String(this.buffer, 0, 7));
        this.header.southEdge[1] = n;
        this.header.southEdge[2] = n2;
        this.header.southEdge[3] = f;
        this.input.read(this.buffer, 0, 4);
        n = Integer.parseInt(new String(this.buffer, 0, 4));
        this.input.read(this.buffer, 0, 2);
        n2 = Integer.parseInt(new String(this.buffer, 0, 2));
        this.input.read(this.buffer, 0, 7);
        f = Float.parseFloat(new String(this.buffer, 0, 7));
        this.header.eastEdge[1] = n;
        this.header.eastEdge[2] = n2;
        this.header.eastEdge[3] = f;
    }

    static {
        processCodes.put('1', new Integer(1));
        processCodes.put('2', new Integer(2));
        processCodes.put('3', new Integer(3));
        processCodes.put('4', new Integer(4));
        processCodes.put('5', new Integer(5));
        processCodes.put('6', new Integer(6));
        processCodes.put('7', new Integer(7));
    }
}

