/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ProgressMonitorInputStream;
import org.j3d.loaders.stl.LittleEndianConverter;
import org.j3d.loaders.stl.STLParser;

class STLBinaryParser
extends STLParser {
    private static final int HEADER_SIZE = 84;
    private static final int RECORD_SIZE = 50;
    private static final int COMMENT_SIZE = 80;
    private BufferedInputStream itsStream;
    private final byte[] itsReadBuffer = new byte[48];
    private final int[] itsDataBuffer = new int[12];

    public void close() throws IOException {
        if (this.itsStream != null) {
            this.itsStream.close();
        }
    }

    public boolean parse(URL uRL) throws IOException {
        int n;
        InputStream inputStream;
        block6: {
            inputStream = null;
            n = -1;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                n = uRLConnection.getContentLength();
            }
            catch (IOException iOException) {
                if (inputStream == null) break block6;
                inputStream.close();
            }
        }
        this.itsStream = new BufferedInputStream(inputStream);
        try {
            int n2 = 0;
            while (n2 < 80) {
                this.itsStream.read();
                ++n2;
            }
            this.itsNumOfObjects = 1;
            this.itsNumOfFacets = new int[]{LittleEndianConverter.read4ByteBlock(this.itsStream)};
            this.itsNames = new String[1];
            if (n != -1 && n != this.itsNumOfFacets[0] * 50 + 84) {
                throw new IOException("File size does not match.");
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        return false;
    }

    public boolean parse(URL uRL, Component component) throws InterruptedIOException, IOException {
        int n;
        InputStream inputStream;
        block6: {
            inputStream = null;
            n = -1;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                n = uRLConnection.getContentLength();
            }
            catch (IOException iOException) {
                if (inputStream == null) break block6;
                inputStream.close();
            }
        }
        inputStream = new ProgressMonitorInputStream(component, "parsing " + uRL.toString(), inputStream);
        this.itsStream = new BufferedInputStream(inputStream);
        try {
            int n2 = 0;
            while (n2 < 80) {
                this.itsStream.read();
                ++n2;
            }
            this.itsNumOfObjects = 1;
            this.itsNumOfFacets = new int[]{LittleEndianConverter.read4ByteBlock(this.itsStream)};
            this.itsNames = new String[1];
            if (n != -1 && n != this.itsNumOfFacets[0] * 50 + 84) {
                throw new IOException("File size does not match.");
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        return false;
    }

    public boolean getNextFacet(double[] dArray, double[][] dArray2) throws InterruptedIOException, IOException {
        LittleEndianConverter.read(this.itsReadBuffer, this.itsDataBuffer, 0, 12, (InputStream)this.itsStream);
        int n = 0;
        while (n < 3) {
            dArray[n] = Float.intBitsToFloat(this.itsDataBuffer[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < 3) {
            int n3 = 0;
            while (n3 < 3) {
                dArray2[n2][n3] = Float.intBitsToFloat(this.itsDataBuffer[n2 * 3 + n3 + 3]);
                ++n3;
            }
            ++n2;
        }
        this.itsStream.read();
        this.itsStream.read();
        return true;
    }
}

