/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.vterrain;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.j3d.loaders.vterrain.BTHeader;

public class BTParser {
    private byte[] buffer = new byte[10];
    private BufferedInputStream input;
    private BTHeader header;
    private float[][] heights;
    private boolean dataReady = false;

    public BTParser() {
    }

    public BTParser(InputStream inputStream) {
        this();
        this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public void reset(InputStream inputStream) {
        this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.dataReady = false;
        this.header = null;
        this.heights = null;
    }

    public BTHeader getHeader() {
        return this.header;
    }

    public float[][] getHeights() {
        return this.heights;
    }

    public float[][] parse() throws IOException {
        if (this.dataReady) {
            throw new IOException("Data has already been read from this stream");
        }
        this.input.read(this.buffer, 0, 10);
        this.header = new BTHeader();
        int n = 0;
        this.header.version = new String(this.buffer, "US-ASCII");
        if (this.header.version.equals("binterr1.0")) {
            n = 0;
        } else if (this.header.version.equals("binterr1.1")) {
            n = 1;
        } else if (this.header.version.equals("binterr1.2")) {
            n = 2;
        }
        this.header.columns = this.readInt();
        int n2 = this.header.rows = this.readInt();
        int n3 = this.header.columns;
        boolean bl = false;
        short s = this.readShort();
        if (n > 0) {
            bl = this.readShort() == 1;
        }
        this.header.utmProjection = this.readShort() == 1;
        this.header.utmZone = this.readShort();
        if (n > 0) {
            this.header.datum = this.readShort();
            this.header.leftExtent = this.readDouble();
            this.header.rightExtent = this.readDouble();
            this.header.bottomExtent = this.readDouble();
            this.header.topExtent = this.readDouble();
        } else {
            this.header.leftExtent = this.readFloat();
            this.header.rightExtent = this.readFloat();
            this.header.bottomExtent = this.readFloat();
            this.header.topExtent = this.readFloat();
            bl = this.readShort() == 1;
        }
        switch (n) {
            case 0: {
                this.input.skip(212L);
                break;
            }
            case 1: {
                this.input.skip(196L);
                break;
            }
            case 2: {
                this.header.needsExternalProj = this.readShort() == 1;
                this.input.skip(194L);
            }
        }
        this.heights = new float[n2][n3];
        boolean bl2 = false;
        if (bl) {
            int n4 = 0;
            while (n4 < n3) {
                int n5 = 0;
                while (n5 < n2) {
                    this.heights[n5][n4] = this.readFloat();
                    ++n5;
                }
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = 0;
                while (n7 < n2) {
                    this.heights[n7][n6] = this.readInt();
                    ++n7;
                }
                ++n6;
            }
        }
        return this.heights;
    }

    private long readLong() throws IOException {
        this.input.read(this.buffer, 0, 8);
        long l = this.buffer[7];
        int n = 6;
        while (n >= 0) {
            l <<= 8;
            l += (long)this.buffer[n];
            --n;
        }
        return l;
    }

    private int readInt() throws IOException {
        this.input.read(this.buffer, 0, 4);
        int n = this.buffer[3];
        int n2 = 2;
        while (n2 >= 0) {
            n <<= 8;
            n += this.buffer[n2];
            --n2;
        }
        return n;
    }

    private short readShort() throws IOException {
        this.input.read(this.buffer, 0, 2);
        short s = this.buffer[1];
        s = (short)(s << 8);
        s = (short)(s + this.buffer[0]);
        return s;
    }

    private float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    private double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }
}

