/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain;

import javax.vecmath.Point3d;
import javax.vecmath.Vector4d;

class Canvas3DFrustum {
    static final int IN = 1;
    static final int OUT = 2;
    static final int CLIPPED = 4;
    Vector4d[] frustumPlanes = new Vector4d[8];

    Canvas3DFrustum() {
        this.frustumPlanes[0] = new Vector4d();
        this.frustumPlanes[1] = new Vector4d();
        this.frustumPlanes[2] = new Vector4d();
        this.frustumPlanes[3] = new Vector4d();
        this.frustumPlanes[4] = new Vector4d();
        this.frustumPlanes[5] = new Vector4d();
        this.frustumPlanes[6] = new Vector4d();
        this.frustumPlanes[7] = new Vector4d();
    }

    int isTriangleInFrustum(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 6) {
            if (this.getDistanceFromPlane(point3d, this.frustumPlanes[n4]) <= 0.0) {
                n |= 1 << n4;
            }
            if (this.getDistanceFromPlane(point3d2, this.frustumPlanes[n4]) <= 0.0) {
                n2 |= 1 << n4;
            }
            if (this.getDistanceFromPlane(point3d3, this.frustumPlanes[n4]) <= 0.0) {
                n3 |= 1 << n4;
            }
            ++n4;
        }
        int n5 = 4;
        if (n == 0 && n2 == 0 && n3 == 0) {
            n5 = 1;
        } else if (n != 0 && n2 != 0 && n3 != 0 && n & n2 & n3) {
            n5 = 2;
        }
        return n5;
    }

    public boolean isPointInFrustum(Point3d point3d) {
        int n = 0;
        while (n < 6) {
            if (this.getDistanceFromPlane(point3d, this.frustumPlanes[n]) <= 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private double getDistanceFromPlane(Point3d point3d, Vector4d vector4d) {
        double d = point3d.x * vector4d.x + point3d.y * vector4d.y + point3d.z * vector4d.z;
        return d + vector4d.w;
    }
}

