/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.util.LinkedList;
import javax.vecmath.Tuple3f;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.ViewFrustum;
import org.j3d.terrain.roam.QueueManager;
import org.j3d.terrain.roam.VarianceTree;
import org.j3d.terrain.roam.VertexData;

class TreeNode {
    public static final int UNDEFINED = -1;
    TreeNode leftChild;
    TreeNode rightChild;
    TreeNode baseNeighbour;
    TreeNode leftNeighbour;
    TreeNode rightNeighbour;
    TreeNode parent;
    private int leftX;
    private int leftY;
    private int rightX;
    private int rightY;
    private int apexX;
    private int apexY;
    private int node;
    private int depth;
    int visible = -1;
    private float p1X;
    private float p1Y;
    private float p1Z;
    private float p2X;
    private float p2Y;
    private float p2Z;
    private float p3X;
    private float p3Y;
    private float p3Z;
    private float p1tS;
    private float p1tT;
    private float p1tR;
    private float p2tS;
    private float p2tT;
    private float p2tR;
    private float p3tS;
    private float p3tT;
    private float p3tR;
    private TerrainData terrainData;
    private VarianceTree varianceTree;
    float variance = 0.0f;
    float diamondVariance = 0.0f;
    boolean diamond = false;
    private boolean textured;
    private static LinkedList nodeCache = new LinkedList();

    TreeNode() {
    }

    TreeNode(int n, int n2, int n3, int n4, int n5, int n6, int n7, TerrainData terrainData, ViewFrustum viewFrustum, int n8, int n9, VarianceTree varianceTree) {
        this.leftX = n;
        this.leftY = n2;
        this.rightX = n3;
        this.rightY = n4;
        this.apexX = n5;
        this.apexY = n6;
        this.node = n7;
        this.terrainData = terrainData;
        this.depth = n9;
        this.varianceTree = varianceTree;
        this.init(viewFrustum, n8);
    }

    void newNode(int n, int n2, int n3, int n4, int n5, int n6, int n7, TerrainData terrainData, ViewFrustum viewFrustum, int n8, int n9, VarianceTree varianceTree) {
        this.leftX = n;
        this.leftY = n2;
        this.rightX = n3;
        this.rightY = n4;
        this.apexX = n5;
        this.apexY = n6;
        this.node = n7;
        this.terrainData = terrainData;
        this.depth = n9;
        this.varianceTree = varianceTree;
        this.init(viewFrustum, n8);
    }

    void reset(ViewFrustum viewFrustum) {
        if (this.leftChild != null) {
            this.leftChild.freeNode();
            this.leftChild = null;
        }
        if (this.rightChild != null) {
            this.rightChild.freeNode();
            this.rightChild = null;
        }
        this.baseNeighbour = null;
        this.leftNeighbour = null;
        this.rightNeighbour = null;
        this.visible = viewFrustum.isTriangleInFrustum(this.p1X, this.p1Y, this.p1Z, this.p2X, this.p2Y, this.p2Z, this.p3X, this.p3Y, this.p3Z);
    }

    boolean isLeaf() {
        return this.leftChild == null;
    }

    void freeNode() {
        if (this.leftChild != null) {
            this.leftChild.freeNode();
            this.leftChild = null;
        }
        if (this.rightChild != null) {
            this.rightChild.freeNode();
            this.rightChild = null;
        }
        this.baseNeighbour = null;
        this.leftNeighbour = null;
        this.rightNeighbour = null;
        this.parent = null;
        this.diamond = false;
        TreeNode.addTreeNode(this);
    }

    void computeVariance(Tuple3f tuple3f, QueueManager queueManager) {
        this.computeVariance(tuple3f);
        queueManager.addTriangle(this);
    }

    void removeDiamond(QueueManager queueManager) {
        if (this.diamond) {
            queueManager.removeDiamond(this);
            this.diamondVariance = 0.0f;
            this.diamond = false;
        } else if (this.baseNeighbour != null && this.baseNeighbour.diamond) {
            queueManager.removeDiamond(this.baseNeighbour);
            this.baseNeighbour.diamondVariance = 0.0f;
            this.baseNeighbour.diamond = false;
        }
    }

    int split(Tuple3f tuple3f, ViewFrustum viewFrustum, QueueManager queueManager) {
        int n = 0;
        if (this.leftChild != null || this.rightChild != null) {
            throw new RuntimeException(" Triangle is already split " + this.node);
        }
        if (this.baseNeighbour != null) {
            if (this.baseNeighbour.baseNeighbour != this) {
                n += this.baseNeighbour.split(tuple3f, viewFrustum, queueManager);
            }
            this.split2(tuple3f, viewFrustum, queueManager);
            ++n;
            this.baseNeighbour.split2(tuple3f, viewFrustum, queueManager);
            ++n;
            this.leftChild.rightNeighbour = this.baseNeighbour.rightChild;
            this.rightChild.leftNeighbour = this.baseNeighbour.leftChild;
            this.baseNeighbour.leftChild.rightNeighbour = this.rightChild;
            this.baseNeighbour.rightChild.leftNeighbour = this.leftChild;
            this.diamondVariance = Math.max(this.variance, this.baseNeighbour.variance);
            this.diamond = true;
            queueManager.addDiamond(this);
        } else {
            this.split2(tuple3f, viewFrustum, queueManager);
            ++n;
            this.diamondVariance = this.variance;
            this.diamond = true;
            queueManager.addDiamond(this);
        }
        return n;
    }

    int merge(QueueManager queueManager) {
        int n = 0;
        if (this.baseNeighbour != null && this.baseNeighbour.baseNeighbour != this) {
            System.out.println("++++++++++++ Illegal merge *********************************");
            queueManager.removeDiamond(this);
            this.diamond = false;
            this.diamondVariance = 0.0f;
            return 0;
        }
        this.merge(this, queueManager);
        ++n;
        this.checkForNewDiamond(this.parent, queueManager);
        if (this.baseNeighbour != null) {
            this.merge(this.baseNeighbour, queueManager);
            ++n;
            this.checkForNewDiamond(this.baseNeighbour.parent, queueManager);
        }
        queueManager.removeDiamond(this);
        this.diamond = false;
        this.diamondVariance = 0.0f;
        return n;
    }

    void getTriangles(VertexData vertexData) {
        if (this.leftChild == null) {
            if (this.visible != 2 && this.visible != -1) {
                if (vertexData.textured) {
                    vertexData.addVertex(this.p1X, this.p1Y, this.p1Z, this.p1tS, this.p1tT);
                    vertexData.addVertex(this.p2X, this.p2Y, this.p2Z, this.p2tS, this.p2tT);
                    vertexData.addVertex(this.p3X, this.p3Y, this.p3Z, this.p3tS, this.p3tT);
                } else {
                    vertexData.addVertex(this.p1X, this.p1Y, this.p1Z, this.p1tS, this.p1tT, this.p1tR);
                    vertexData.addVertex(this.p2X, this.p2Y, this.p2Z, this.p2tS, this.p2tT, this.p2tR);
                    vertexData.addVertex(this.p3X, this.p3Y, this.p3Z, this.p3tS, this.p3tT, this.p3tR);
                }
            }
        } else {
            this.leftChild.getTriangles(vertexData);
            this.rightChild.getTriangles(vertexData);
        }
    }

    void updateTree(Tuple3f tuple3f, ViewFrustum viewFrustum, VarianceTree varianceTree, int n, QueueManager queueManager) {
        this.visible = n == -1 || n == 4 ? viewFrustum.isTriangleInFrustum(this.p1X, this.p1Y, this.p1Z, this.p2X, this.p2Y, this.p2Z, this.p3X, this.p3Y, this.p3Z) : n;
        if (this.leftChild == null && this.rightChild == null && this.depth < varianceTree.getMaxDepth() && this.visible != 2) {
            this.computeVariance(tuple3f);
            queueManager.addTriangle(this);
        } else {
            if (this.leftChild != null) {
                this.leftChild.updateTree(tuple3f, viewFrustum, varianceTree, this.visible, queueManager);
            }
            if (this.rightChild != null) {
                this.rightChild.updateTree(tuple3f, viewFrustum, varianceTree, this.visible, queueManager);
            }
            if (this.diamond) {
                if (this.visible != 2) {
                    this.computeVariance(tuple3f);
                    this.diamondVariance = this.baseNeighbour != null ? Math.max(this.variance, this.baseNeighbour.variance) : this.variance;
                } else {
                    this.diamondVariance = Float.MIN_VALUE;
                }
                queueManager.addDiamond(this);
            }
        }
    }

    public String toString() {
        return Integer.toString(this.node);
    }

    private void init(ViewFrustum viewFrustum, int n) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        boolean bl = this.terrainData.hasTexture();
        if (bl) {
            this.terrainData.getCoordinateWithTexture(fArray, fArray2, this.leftX, this.leftY);
        } else {
            this.terrainData.getCoordinateWithColor(fArray, fArray2, this.leftX, this.leftY);
        }
        this.p1X = fArray[0];
        this.p1Y = fArray[1];
        this.p1Z = fArray[2];
        this.p1tS = fArray2[0];
        this.p1tT = fArray2[1];
        this.p1tR = fArray2[2];
        if (bl) {
            this.terrainData.getCoordinateWithTexture(fArray, fArray2, this.rightX, this.rightY);
        } else {
            this.terrainData.getCoordinateWithColor(fArray, fArray2, this.rightX, this.rightY);
        }
        this.p2X = fArray[0];
        this.p2Y = fArray[1];
        this.p2Z = fArray[2];
        this.p2tS = fArray2[0];
        this.p2tT = fArray2[1];
        this.p2tR = fArray2[2];
        if (bl) {
            this.terrainData.getCoordinateWithTexture(fArray, fArray2, this.apexX, this.apexY);
        } else {
            this.terrainData.getCoordinateWithColor(fArray, fArray2, this.apexX, this.apexY);
        }
        this.p3X = fArray[0];
        this.p3Y = fArray[1];
        this.p3Z = fArray[2];
        this.p3tS = fArray2[0];
        this.p3tT = fArray2[1];
        this.p3tR = fArray2[2];
        this.visible = n == -1 || n == 4 ? viewFrustum.isTriangleInFrustum(this.p1X, this.p1Y, this.p1Z, this.p2X, this.p2Y, this.p2Z, this.p3X, this.p3Y, this.p3Z) : n;
        this.variance = 0.0f;
    }

    private void computeVariance(Tuple3f tuple3f) {
        float f = (this.p1X + this.p2X) * 0.5f;
        float f2 = -(this.p1Y + this.p2Y) * 0.5f;
        float f3 = (tuple3f.x - f) * (tuple3f.x - f);
        float f4 = (tuple3f.z - f2) * (tuple3f.z - f2);
        float f5 = (float)Math.sqrt(f3 + f4);
        float f6 = (float)this.varianceTree.getVariance(this.node) / f5;
        this.variance = (float)Math.abs(Math.atan(f6));
    }

    private void splitTriangle(Tuple3f tuple3f, ViewFrustum viewFrustum, QueueManager queueManager) {
        int n = (this.leftX + this.rightX) / 2;
        int n2 = (this.leftY + this.rightY) / 2;
        if (this.parent != null) {
            this.parent.removeDiamond(queueManager);
        }
        this.leftChild = TreeNode.getTreeNode();
        this.rightChild = TreeNode.getTreeNode();
        this.leftChild.newNode(this.apexX, this.apexY, this.leftX, this.leftY, n, n2, this.node << 1, this.terrainData, viewFrustum, this.visible, this.depth + 1, this.varianceTree);
        this.rightChild.newNode(this.rightX, this.rightY, this.apexX, this.apexY, n, n2, 1 + (this.node << 1), this.terrainData, viewFrustum, this.visible, this.depth + 1, this.varianceTree);
        this.leftChild.parent = this;
        this.rightChild.parent = this;
        if (this.depth + 1 < this.varianceTree.getMaxDepth() && this.visible != 2) {
            this.rightChild.computeVariance(tuple3f, queueManager);
            this.leftChild.computeVariance(tuple3f, queueManager);
        }
    }

    private void split2(Tuple3f tuple3f, ViewFrustum viewFrustum, QueueManager queueManager) {
        this.splitTriangle(tuple3f, viewFrustum, queueManager);
        queueManager.removeTriangle(this);
        this.leftChild.leftNeighbour = this.rightChild;
        this.rightChild.rightNeighbour = this.leftChild;
        this.leftChild.baseNeighbour = this.leftNeighbour;
        if (this.leftNeighbour != null) {
            if (this.leftNeighbour.baseNeighbour == this) {
                this.leftNeighbour.baseNeighbour = this.leftChild;
            } else if (this.leftNeighbour.leftNeighbour == this) {
                this.leftNeighbour.leftNeighbour = this.leftChild;
            } else {
                this.leftNeighbour.rightNeighbour = this.leftChild;
            }
        }
        this.rightChild.baseNeighbour = this.rightNeighbour;
        if (this.rightNeighbour != null) {
            if (this.rightNeighbour.baseNeighbour == this) {
                this.rightNeighbour.baseNeighbour = this.rightChild;
            } else if (this.rightNeighbour.rightNeighbour == this) {
                this.rightNeighbour.rightNeighbour = this.rightChild;
            } else {
                this.rightNeighbour.leftNeighbour = this.rightChild;
            }
        }
    }

    private void merge(TreeNode treeNode, QueueManager queueManager) {
        if (treeNode.leftChild == null || treeNode.rightChild == null || !treeNode.leftChild.isLeaf() || !treeNode.rightChild.isLeaf()) {
            throw new RuntimeException("Illegal merge");
        }
        if (treeNode.leftNeighbour != null) {
            if (treeNode.leftNeighbour.baseNeighbour == treeNode.leftChild) {
                treeNode.leftNeighbour.baseNeighbour = treeNode;
            } else if (treeNode.leftNeighbour.leftNeighbour == treeNode.leftChild) {
                treeNode.leftNeighbour.leftNeighbour = treeNode;
            } else {
                treeNode.leftNeighbour.rightNeighbour = treeNode;
            }
        }
        if (treeNode.rightNeighbour != null) {
            if (treeNode.rightNeighbour.baseNeighbour == treeNode.rightChild) {
                treeNode.rightNeighbour.baseNeighbour = treeNode;
            } else if (treeNode.rightNeighbour.rightNeighbour == treeNode.rightChild) {
                treeNode.rightNeighbour.rightNeighbour = treeNode;
            } else {
                treeNode.rightNeighbour.leftNeighbour = treeNode;
            }
        }
        if (treeNode.leftChild.baseNeighbour != null && treeNode.leftChild.baseNeighbour.baseNeighbour == treeNode.leftChild) {
            treeNode.leftChild.baseNeighbour.baseNeighbour = treeNode;
        }
        if (treeNode.rightChild.baseNeighbour != null && treeNode.rightChild.baseNeighbour.baseNeighbour == treeNode.rightChild) {
            treeNode.rightChild.baseNeighbour.baseNeighbour = treeNode;
        }
        treeNode.leftNeighbour = treeNode.leftChild.baseNeighbour;
        treeNode.rightNeighbour = treeNode.rightChild.baseNeighbour;
        if (treeNode.visible != 2) {
            queueManager.addTriangle(treeNode);
        }
        queueManager.removeTriangle(treeNode.leftChild);
        queueManager.removeTriangle(treeNode.rightChild);
        treeNode.leftChild.freeNode();
        treeNode.leftChild = null;
        treeNode.rightChild.freeNode();
        treeNode.rightChild = null;
    }

    private void checkForNewDiamond(TreeNode treeNode, QueueManager queueManager) {
        if (treeNode == null) {
            return;
        }
        if (treeNode.leftChild.isLeaf() && treeNode.rightChild.isLeaf() && (treeNode.baseNeighbour == null || treeNode.baseNeighbour.leftChild == null || treeNode.baseNeighbour.leftChild.isLeaf() && treeNode.baseNeighbour.rightChild.isLeaf())) {
            treeNode.diamond = true;
            treeNode.diamondVariance = treeNode.visible != 2 ? (treeNode.baseNeighbour != null ? Math.max(treeNode.variance, treeNode.baseNeighbour.variance) : treeNode.variance) : Float.MIN_VALUE;
            queueManager.addDiamond(treeNode);
        }
    }

    private static TreeNode getTreeNode() {
        TreeNode treeNode = nodeCache.size() > 0 ? (TreeNode)nodeCache.removeFirst() : new TreeNode();
        return treeNode;
    }

    private static void addTreeNode(TreeNode treeNode) {
        nodeCache.add(treeNode);
    }
}

