/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.texture;

import org.j3d.texture.CacheAlreadySetException;
import org.j3d.texture.FixedTextureCache;
import org.j3d.texture.LRUTextureCache;
import org.j3d.texture.TextureCache;
import org.j3d.texture.WeakRefTextureCache;
import org.j3d.util.IntHashMap;

public class TextureCacheFactory {
    private static final int NO_CACHE_SET = -1;
    public static final int FIXED_CACHE = 1;
    public static final int LRU_CACHE = 2;
    public static final int WEAKREF_CACHE = 3;
    public static final int LAST_CACHE_ID = 10;
    private static final int DEFAULT_CACHE_ID = 1;
    public static final String DEFAULT_CACHE_PROP = "org.j3d.texture.DefaultCacheType";
    private static IntHashMap cacheMap = new IntHashMap();
    private static int defaultCacheType = -1;

    private TextureCacheFactory() {
    }

    public static void setDefaultCacheType(int n) throws CacheAlreadySetException {
        if (defaultCacheType != -1) {
            throw new CacheAlreadySetException();
        }
        defaultCacheType = n;
    }

    public static TextureCache getCache() {
        if (defaultCacheType == -1) {
            String string = System.getProperty(DEFAULT_CACHE_PROP);
            defaultCacheType = string == null ? 1 : (string.equals("fixed") ? 1 : (string.equals("lru") ? 2 : (string.equals("weakref") ? 3 : 1)));
        }
        return TextureCacheFactory.getCache(defaultCacheType);
    }

    public static TextureCache getCache(int n) {
        TextureCache textureCache = (TextureCache)cacheMap.get(n);
        if (textureCache == null) {
            switch (n) {
                case 1: {
                    textureCache = new FixedTextureCache();
                    cacheMap.put(1, textureCache);
                    break;
                }
                case 2: {
                    textureCache = new LRUTextureCache();
                    cacheMap.put(2, textureCache);
                    break;
                }
                case 3: {
                    textureCache = new WeakRefTextureCache();
                    cacheMap.put(3, textureCache);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid cache type");
                }
            }
        }
        return textureCache;
    }

    public static void registerCacheType(int n, TextureCache textureCache) {
        if (n <= 10) {
            throw new IllegalArgumentException("Invalid cacheType value");
        }
        cacheMap.put(n, textureCache);
    }
}

