/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.ui;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.vecmath.Point3f;
import org.j3d.ui.CapturedImageObserver;

public class ImageCaptureCanvas3D
extends Canvas3D {
    private transient boolean captureImage = false;
    private transient LinkedList observers = new LinkedList();

    public ImageCaptureCanvas3D(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
    }

    public ImageCaptureCanvas3D(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        super(graphicsConfiguration, bl);
    }

    public void postSwap() {
        if (!this.captureImage) {
            return;
        }
        GraphicsContext3D graphicsContext3D = this.getGraphicsContext3D();
        Rectangle rectangle = this.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, bufferedImage, true, false);
        Raster raster = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, 0, 0, rectangle.width, rectangle.height, imageComponent2D, null);
        graphicsContext3D.readRaster(raster);
        this.notifyObservers(bufferedImage);
    }

    public void addCaptureObserver(CapturedImageObserver capturedImageObserver) {
        if (capturedImageObserver != null && !this.observers.contains(capturedImageObserver)) {
            this.observers.add(capturedImageObserver);
            this.captureImage = true;
        }
    }

    public void removeCaptureObserver(CapturedImageObserver capturedImageObserver) {
        if (capturedImageObserver != null) {
            this.observers.remove(capturedImageObserver);
            if (this.observers.size() == 0) {
                this.captureImage = false;
            }
        }
    }

    private void notifyObservers(BufferedImage bufferedImage) {
        Iterator iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            CapturedImageObserver capturedImageObserver = (CapturedImageObserver)iterator.next();
            try {
                capturedImageObserver.canvasImageCaptured(bufferedImage);
            }
            catch (Exception exception) {
                System.err.println("Error sending image to observer");
                exception.printStackTrace();
            }
        }
    }
}

