/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.ui.navigation;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.IntersectionUtils;
import org.j3d.ui.navigation.CollisionListener;
import org.j3d.ui.navigation.FrameUpdateListener;
import org.j3d.ui.navigation.NavigationStateListener;

public class NavigationHandler {
    private static final float DEFAULT_AVATAR_HEIGHT = 1.8f;
    private static final float DEFAULT_AVATAR_SIZE = 0.25f;
    private static final float DEFAULT_STEP_HEIGHT = 0.4f;
    private static final Vector3d Y_DOWN = new Vector3d(0.0, -1.0, 0.0);
    private static final Vector3d COLLISION_DIRECTION = new Vector3d(0.0, 0.0, -1.0);
    private IntersectionUtils terrainIntersect = new IntersectionUtils();
    private IntersectionUtils collideIntersect = new IntersectionUtils();
    private View view;
    private TransformGroup viewTg = new TransformGroup();
    private Transform3D viewTx = new Transform3D();
    private NavigationStateListener navigationListener;
    private CollisionListener collisionListener;
    private int navigationState = 0;
    private int previousState = 0;
    private int buttonOneState = 0;
    private int buttonTwoState = 0;
    private int buttonThreeState = 0;
    private boolean movementInProgress = false;
    private int activeButton;
    private float speed = 0.0f;
    private BranchGroup terrain;
    private BranchGroup collidables;
    private PickRay terrainPicker;
    private PickSegment collisionPicker;
    private Vector3d downVector;
    private Vector3d collisionVector;
    private FrameUpdateListener updateListener;
    private float avatarHeight = 1.8f;
    private float avatarSize = 0.25f;
    private float avatarStep = 0.4f;
    private float lastTerrainHeight = 0.0f;
    private Vector3d locationVector;
    private Point3d locationPoint;
    private Point3d locationEndPoint;
    private Point3d wkPoint;
    private Vector3d diffVec;
    private Point3d intersectionPoint;
    private Vector3d dragTranslationAmt;
    private Vector3d oneFrameTranslation;
    private Transform3D oneFrameRotation;
    private Vector3d viewTranslation;
    private Transform3D worldEyeTransform = new Transform3D();
    private double mouseRotationY = 0.0;
    private double mouseRotationX = 0.0;
    private Point2d startMousePos;
    private Point2d latestMousePos;
    private Point2d mouseDifference;
    private boolean allowCollisions = false;
    private boolean allowTerrainFollowing = false;
    private double angle;
    private FrameTimerBehavior frameTimer;
    private long startFrameDurationCalc;

    public NavigationHandler() {
        this.downVector = new Vector3d();
        this.terrainPicker = new PickRay();
        this.collisionVector = new Vector3d();
        this.collisionPicker = new PickSegment();
        this.intersectionPoint = new Point3d();
        this.wkPoint = new Point3d();
        this.diffVec = new Vector3d();
        this.locationVector = new Vector3d();
        this.locationPoint = new Point3d();
        this.locationEndPoint = new Point3d();
        this.dragTranslationAmt = new Vector3d();
        this.oneFrameTranslation = new Vector3d();
        this.oneFrameRotation = new Transform3D();
        this.viewTranslation = new Vector3d();
        this.startMousePos = new Point2d();
        this.latestMousePos = new Point2d();
        this.mouseDifference = new Point2d();
        BoundingSphere boundingSphere = new BoundingSphere();
        boundingSphere.setRadius(Double.POSITIVE_INFINITY);
        this.frameTimer = new FrameTimerBehavior();
        this.frameTimer.setSchedulingBounds((Bounds)boundingSphere);
        this.frameTimer.setEnable(false);
    }

    public Behavior getTimerBehavior() {
        return this.frameTimer;
    }

    public void setViewInfo(View view, TransformGroup transformGroup) {
        if (view != null && transformGroup == null || view == null && transformGroup != null) {
            throw new IllegalArgumentException("View or TG is null when the other isn't");
        }
        this.view = view;
        this.viewTg = transformGroup;
        if (transformGroup == null) {
            return;
        }
        if (transformGroup.isLive()) {
            if (!this.viewTg.getCapability(11)) {
                throw new IllegalStateException("Live scenegraph and cannot read the VWorld transform");
            }
        } else {
            transformGroup.setCapability(11);
        }
    }

    public void setWorldInfo(BranchGroup branchGroup, BranchGroup branchGroup2) {
        this.terrain = branchGroup;
        this.collidables = branchGroup2;
    }

    public void setAvatarInfo(float f, float f2, float f3) {
        this.avatarHeight = f;
        this.avatarSize = f2;
        this.avatarStep = f3;
    }

    public void setNavigationSpeed(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative speed value");
        }
        this.speed = f;
    }

    public void setButtonNavigation(int n, int n2) {
        switch (n) {
            case 16: {
                this.buttonOneState = n2;
                break;
            }
            case 8: {
                this.buttonTwoState = n2;
                break;
            }
            case 4: {
                this.buttonThreeState = n2;
            }
        }
    }

    public void setNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.navigationListener = navigationStateListener;
    }

    public void setCollisionListener(CollisionListener collisionListener) {
        this.collisionListener = collisionListener;
    }

    public int getNavigationState() {
        return this.navigationState;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.viewTg == null) {
            return;
        }
        this.latestMousePos.set((double)mouseEvent.getX(), (double)mouseEvent.getY());
        this.mouseDifference.sub((Tuple2d)this.startMousePos, (Tuple2d)this.latestMousePos);
        switch (this.navigationState) {
            case 4: {
                this.dragTranslationAmt.set(0.0, 0.0, -this.mouseDifference.y * (double)this.speed);
                this.mouseRotationY = this.mouseDifference.x;
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = false;
                break;
            }
            case 3: {
                this.dragTranslationAmt.set(-this.mouseDifference.x * 2.0, this.mouseDifference.y * 2.0, 0.0);
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 2: {
                this.mouseRotationX = this.mouseDifference.y;
                this.mouseRotationY = this.mouseDifference.x;
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 1: {
                this.dragTranslationAmt.set(0.0, 0.0, -this.mouseDifference.y * (double)this.speed);
                this.mouseRotationY = this.mouseDifference.x;
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = this.terrain != null;
                break;
            }
            case 5: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 0: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.movementInProgress || this.viewTg == null) {
            return;
        }
        int n = mouseEvent.getModifiers();
        this.previousState = this.navigationState;
        this.activeButton = n & 0x10;
        if ((n & 0x10) != 0) {
            this.navigationState = this.buttonOneState;
        } else if ((n & 8) != 0) {
            this.navigationState = this.buttonTwoState;
        } else if ((n & 4) != 0) {
            this.navigationState = this.buttonThreeState;
        }
        if (this.navigationListener != null) {
            this.navigationListener.setNavigationState(this.navigationState);
        }
        if (this.navigationState == 0) {
            return;
        }
        this.viewTg.getTransform(this.viewTx);
        this.viewTx.get(this.viewTranslation);
        this.startMousePos.set((double)mouseEvent.getX(), (double)mouseEvent.getY());
        this.startFrameDurationCalc = System.currentTimeMillis();
        this.frameTimer.setEnable(true);
        if (this.navigationState == 1 && this.allowTerrainFollowing) {
            this.setInitialTerrainHeight();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (this.viewTg == null || this.movementInProgress && ((long)n & 0x10L) != (long)this.activeButton) {
            return;
        }
        this.movementInProgress = false;
        this.allowCollisions = false;
        this.allowTerrainFollowing = false;
        this.frameTimer.setEnable(false);
        this.viewTx.normalize();
        this.mouseRotationY = 0.0;
        this.mouseRotationX = 0.0;
        this.oneFrameRotation.setIdentity();
        this.dragTranslationAmt.scale(0.0);
        this.viewTg.getTransform(this.viewTx);
        this.navigationState = this.previousState;
        if (this.navigationListener != null) {
            this.navigationListener.setNavigationState(this.previousState);
        }
    }

    private boolean checkTerrainFollowing() {
        boolean bl = true;
        this.viewTg.getLocalToVworld(this.worldEyeTransform);
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.worldEyeTransform.transform(Y_DOWN, this.downVector);
        this.locationPoint.add((Tuple3d)this.locationVector, (Tuple3d)this.oneFrameTranslation);
        this.terrainPicker.set(this.locationPoint, this.downVector);
        SceneGraphPath[] sceneGraphPathArray = this.terrain.pickAllSorted((PickShape)this.terrainPicker);
        if (sceneGraphPathArray == null || sceneGraphPathArray.length == 0) {
            return bl;
        }
        double d = -1.0;
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            Transform3D transform3D = sceneGraphPathArray[n].getTransform();
            transform3D.get(this.locationVector);
            Shape3D shape3D = (Shape3D)sceneGraphPathArray[n].getObject();
            Enumeration enumeration = shape3D.getAllGeometries();
            while (enumeration.hasMoreElements()) {
                GeometryArray geometryArray = (GeometryArray)enumeration.nextElement();
                if (geometryArray == null || !this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryArray, transform3D, this.wkPoint, false)) continue;
                this.diffVec.sub((Tuple3d)this.locationPoint, (Tuple3d)this.wkPoint);
                if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) continue;
                d = this.diffVec.lengthSquared();
                this.intersectionPoint.set((Tuple3d)this.wkPoint);
            }
            ++n;
        }
        if (d == -1.0) {
            return true;
        }
        double d2 = this.intersectionPoint.y - (double)this.lastTerrainHeight;
        double d3 = this.locationPoint.y - this.intersectionPoint.y;
        if (d3 != (double)this.avatarHeight) {
            if (d2 == 0.0) {
                this.oneFrameTranslation.y = (double)this.avatarHeight - d3;
            } else if (d2 < (double)this.avatarStep) {
                this.oneFrameTranslation.y += d2;
                bl = true;
            } else {
                bl = false;
            }
        }
        this.lastTerrainHeight = (float)this.intersectionPoint.y;
        return bl;
    }

    private boolean checkCollisions() {
        boolean bl = true;
        this.viewTg.getLocalToVworld(this.worldEyeTransform);
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.locationPoint.set((Tuple3d)this.locationVector);
        this.worldEyeTransform.transform(COLLISION_DIRECTION, this.collisionVector);
        this.collisionVector.scale((double)this.avatarSize);
        this.locationEndPoint.add((Tuple3d)this.locationVector, (Tuple3d)this.collisionVector);
        this.locationEndPoint.add((Tuple3d)this.oneFrameTranslation);
        this.collisionPicker.set(this.locationPoint, this.locationEndPoint);
        SceneGraphPath[] sceneGraphPathArray = this.collidables.pickAllSorted((PickShape)this.collisionPicker);
        if (sceneGraphPathArray == null || sceneGraphPathArray.length == 0) {
            return true;
        }
        boolean bl2 = false;
        float f = (float)this.collisionVector.length();
        int n = 0;
        while (n < sceneGraphPathArray.length && !bl2) {
            Transform3D transform3D = sceneGraphPathArray[n].getTransform();
            Shape3D shape3D = (Shape3D)sceneGraphPathArray[n].getObject();
            Enumeration enumeration = shape3D.getAllGeometries();
            while (enumeration.hasMoreElements() && !bl2) {
                GeometryArray geometryArray = (GeometryArray)enumeration.nextElement();
                if (geometryArray == null) continue;
                bl2 = this.collideIntersect.rayUnknownGeometry(this.locationPoint, this.collisionVector, f, geometryArray, transform3D, this.wkPoint, true);
            }
            bl = !bl2;
            ++n;
        }
        return bl;
    }

    public void setFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.updateListener = frameUpdateListener;
    }

    private void setInitialTerrainHeight() {
        if (this.terrain == null) {
            return;
        }
        this.viewTg.getLocalToVworld(this.worldEyeTransform);
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.worldEyeTransform.transform(Y_DOWN, this.downVector);
        this.locationPoint.set((Tuple3d)this.locationVector);
        this.terrainPicker.set(this.locationPoint, this.downVector);
        SceneGraphPath[] sceneGraphPathArray = this.terrain.pickAllSorted((PickShape)this.terrainPicker);
        if (sceneGraphPathArray == null) {
            return;
        }
        double d = -1.0;
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            Transform3D transform3D = sceneGraphPathArray[n].getTransform();
            transform3D.get(this.locationVector);
            Shape3D shape3D = (Shape3D)sceneGraphPathArray[n].getObject();
            Enumeration enumeration = shape3D.getAllGeometries();
            while (enumeration.hasMoreElements()) {
                GeometryArray geometryArray = (GeometryArray)enumeration.nextElement();
                if (geometryArray == null || !this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryArray, transform3D, this.wkPoint, false)) continue;
                this.diffVec.sub((Tuple3d)this.locationPoint, (Tuple3d)this.wkPoint);
                if (d != -1.0 && !(this.diffVec.length() < d)) continue;
                d = this.diffVec.length();
                this.intersectionPoint.set((Tuple3d)this.wkPoint);
            }
            ++n;
        }
        if (d != -1.0) {
            this.lastTerrainHeight = (float)this.intersectionPoint.y;
        }
    }

    private class FrameTimerBehavior
    extends Behavior {
        protected WakeupCondition FPSCriterion;
        protected long frameDuration = 0L;

        public void initialize() {
            this.FPSCriterion = new WakeupOnElapsedFrames(0, false);
            this.wakeupOn(this.FPSCriterion);
        }

        public void processStimulus(Enumeration enumeration) {
            this.frameDuration = System.currentTimeMillis() - NavigationHandler.this.startFrameDurationCalc;
            double d = 5.0E-6 * (double)this.frameDuration;
            NavigationHandler.this.oneFrameRotation.rotX(NavigationHandler.this.mouseRotationX * d);
            NavigationHandler.this.viewTx.mul(NavigationHandler.this.oneFrameRotation);
            NavigationHandler.this.oneFrameRotation.rotY(NavigationHandler.this.mouseRotationY * d);
            NavigationHandler.this.viewTx.mul(NavigationHandler.this.oneFrameRotation);
            NavigationHandler.this.oneFrameTranslation.set((Tuple3d)NavigationHandler.this.dragTranslationAmt);
            NavigationHandler.this.oneFrameTranslation.scale(d);
            NavigationHandler.this.viewTx.transform(NavigationHandler.this.oneFrameTranslation);
            boolean bl = false;
            if (NavigationHandler.this.allowCollisions) {
                boolean bl2 = bl = !NavigationHandler.this.checkCollisions();
            }
            if (NavigationHandler.this.allowTerrainFollowing && !bl) {
                boolean bl3 = bl = !NavigationHandler.this.checkTerrainFollowing();
            }
            if (bl) {
                if (NavigationHandler.this.collisionListener != null) {
                    NavigationHandler.this.collisionListener.avatarCollision();
                }
                ((NavigationHandler)NavigationHandler.this).oneFrameTranslation.z = 0.0;
            }
            NavigationHandler.this.viewTranslation.add((Tuple3d)NavigationHandler.this.oneFrameTranslation);
            NavigationHandler.this.viewTx.setTranslation(NavigationHandler.this.viewTranslation);
            try {
                NavigationHandler.this.viewTg.setTransform(NavigationHandler.this.viewTx);
            }
            catch (Exception exception) {
                NavigationHandler.this.viewTx.rotX(0.0);
                NavigationHandler.this.viewTg.setTransform(NavigationHandler.this.viewTx);
            }
            NavigationHandler.this.startFrameDurationCalc = System.currentTimeMillis();
            if (NavigationHandler.this.updateListener != null) {
                try {
                    NavigationHandler.this.updateListener.viewerPositionUpdated(NavigationHandler.this.viewTx);
                }
                catch (Exception exception) {
                    System.out.println("Error sending frame update message");
                    exception.printStackTrace();
                }
            }
            this.wakeupOn(this.FPSCriterion);
        }
    }
}

