/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

public abstract class Interpolator {
    public static final int LINEAR = 1;
    public static final int STEP = 2;
    protected static final int DEFAULT_SIZE = 20;
    protected static final int ARRAY_INCREMENT = 5;
    protected int allocatedSize;
    protected int currentSize;
    protected float[] keys;
    protected final int interpolationType;

    protected Interpolator() {
        this(20, 1);
    }

    protected Interpolator(int n) {
        this(n, 1);
    }

    protected Interpolator(int n, int n2) {
        this.interpolationType = n2;
        this.keys = new float[n];
    }

    protected int findKeyIndex(float f) {
        if (f <= this.keys[0] || this.currentSize == 0) {
            return -1;
        }
        if (f == this.keys[this.currentSize - 1]) {
            return this.currentSize - 1;
        }
        if (f > this.keys[this.currentSize - 1]) {
            return this.currentSize;
        }
        int n = -1;
        int n2 = 1;
        while (n2 < this.currentSize) {
            if (this.keys[n2] > f) {
                n = n2 - 1;
                break;
            }
            ++n2;
        }
        return n;
    }
}

