/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import org.j3d.util.interpolator.Interpolator;

public class ScalarInterpolator
extends Interpolator {
    private float[] keyValues;

    public ScalarInterpolator() {
        this(20, 1);
    }

    public ScalarInterpolator(int n) {
        this(n, 1);
    }

    public ScalarInterpolator(int n, int n2) {
        super(n, n2);
        this.keyValues = new float[n];
    }

    public void addKeyFrame(float f, float f2) {
        int n = this.findKeyIndex(f);
        this.realloc();
        if (n < 0) {
            n = 0;
        }
        if (n >= this.currentSize) {
            this.keyValues[this.currentSize] = f2;
        } else {
            if (this.keys[n] != f) {
                ++n;
            }
            int n2 = this.currentSize - n;
            System.arraycopy(this.keyValues, n, this.keyValues, n + 1, n2);
            System.arraycopy(this.keys, n, this.keys, n + 1, n2);
            this.keyValues[n] = f2;
        }
        this.keys[n] = f;
        ++this.currentSize;
    }

    public float floatValue(float f) {
        float f2;
        int n = this.findKeyIndex(f);
        if (n < 0) {
            f2 = this.keyValues[0];
        } else if (n >= this.currentSize - 1) {
            f2 = this.keyValues[this.currentSize - 1];
        } else {
            switch (this.interpolationType) {
                case 1: {
                    float f3 = this.keyValues[n + 1];
                    float f4 = this.keyValues[n];
                    float f5 = f3 - f4;
                    float f6 = 0.0f;
                    float f7 = this.keys[n];
                    float f8 = this.keys[n + 1];
                    if (f8 != f7) {
                        f6 = (f - f7) / (f8 - f7);
                    }
                    f2 = f4 + f6 * f5;
                    break;
                }
                case 2: {
                    f2 = this.keyValues[n];
                    break;
                }
                default: {
                    f2 = 0.0f;
                }
            }
        }
        return f2;
    }

    private final void realloc() {
        if (this.currentSize == this.allocatedSize) {
            int n = this.allocatedSize + 5;
            float[] fArray = new float[n];
            System.arraycopy(this.keyValues, 0, fArray, 0, this.allocatedSize);
            float[] fArray2 = new float[n];
            System.arraycopy(this.keys, 0, fArray2, 0, this.allocatedSize);
            this.keys = fArray2;
            this.keyValues = fArray;
            this.allocatedSize = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<scalar interpolator>\n");
        int n = 0;
        while (n < this.currentSize) {
            stringBuffer.append(n);
            stringBuffer.append(" key: ");
            stringBuffer.append(this.keys[n]);
            stringBuffer.append(" value: ");
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("</scalar interpolator>");
        return stringBuffer.toString();
    }
}

