--Example of a Goppa code
restart
loadPackage "agcodes"

R=GF(8)[x,y,z]/(x^3*y+y^3*z+z^3*x)
Y=Proj(R) -- The Klein curve over F_8
L=rpoints(Y)-- A list of all rational points of X
#L -- We have 24 rational points
Z=sum(L)-L_0 --This is the ZeroCycle where we evaluate the code
D=divisor(6*L_0,Y)--A divisor of degree 6 on X
C=agcode(D,Z)--We get a [23,4,?] Goppa code.

--Now for the fun stuff
restart
loadPackage "agcodes"
loadPackage "ConvexPolyhedron"
loadPackage "toriccodes"


--Joyner's Example
K=GF(GF(2)[a]/(a^3+a+1), Variable=>a) --This is GF(8) as defined in Magma

P=convexHull matrix {{0,1,4},{0,4,1}} --A nice polytope
C1=toriccode(P,K) --And the corresponding [49,11,27] toric code

--We can also get an equivalent T-Code:

Y=Proj(K[x,y,z]/z)-- P^1
L=rpoints(Y)--9 rational points, of course
#L

P1=convexHull matrix {{0,1,4},{0,4,1}}-- One polyhedral coefficient
P2=convexHull matrix {{0,4},{0,-1}}-- Another polyhedral coefficient
--All that counts is the "upper" boundary

h=divpoly{{P1,L_0},{P2,L_8}}--Our divisorial polytope
Z=(sum L)-L_0-L_8--The set "\mathcal{P}"
C2=tcode(Y,h,Z)--An equivalent [49,11,27] code


--A code over an elliptic curve
restart
loadPackage "ConvexPolyhedron"
loadPackage "agcodes"
loadPackage "toriccodes"

K=GF(7)
b=0;c=4;
Y=Proj(K[x,y,z]/(z*y^2-(x^3-b*x*z^2-c*z^3))); --A nonsingular elliptic curve
L=rpoints(Y) --The list of rational points
#L -- 13 is the maximum possible

P1=convexHull matrix {{0,5},{0,6}}
P2=convexHull matrix {{0,1,2,3,5},{0,2,3,3,-5}}
h1=divpoly{{P1,L_0},{P2,L_1}}--One divisorial polytope
h2=divpoly{{P1,L_0},{P2,L_2}}--One divisorial polytope
Z1=(sum L)-L_0-L_1--The set "\mathcal{P}"
Z2=(sum L)-L_0-L_2--The set "\mathcal{P}"
C1=tcode(Y,h1,Z1)--A [66,19,30] code
C2=tcode(Y,h2,Z2)--A [66,19,29] code

--The first code is as good as best known!