newPackage(
	"toriccodes",
	Version => "0.1",
	Date => "October 5, 2008",
	Authors => {{Name => "Nathan Ilten", Email => "nilten@cs.uchicago.edu>"}},
	HomePage => "http://people.cs.uchicago.edu/~nilten/",
	Headline => "A Macaulay2 package for computing with toric codes",
        DebuggingMode => true
	)
        
export{
	divpoly,
	weightpoly,
	fhstar,
	tcode,
	toriccode,
	multipower
	}
	
needsPackage("ConvexPolyhedron")
needsPackage("agcodes")

-- methods
divpoly = method() 
toriccode = method()
multipower = method()
weightpoly = method()
fhstar = method()
tcode = method()

-- this might really belong in Rene's package
Polyhedron + Polyhedron:=(P,Q)->minkowskisum(P,Q)
Polyhedron == Polyhedron:=(P,Q)->((sort vertices P)==(sort vertices Q)) -- This only works for P,Q compact
Polyhedron == ZZ:=(P,n)->(P==(convexHull matrix {{n}}))
ZZ == Polyhedron:=(n,P)->(P==n)

--Purpose: Create a new divisorial polytope as a ZeroCycle
--Input: A List of Lists, each consisting of a Polyhedron and an RPoint
--Output: A ZeroCycle with polyhedral coefficients
--Note: The input polyhedra are the convex hulls of the graphs of the relevant convex functions
divpoly List:=L -> new ZeroCycle from L

--Purpose: Calculate the weight polytope of a divisorial polytope
--Input: A divisorial polytope as ZeroCycle
--Output: A Polyhedron
weightpoly ZeroCycle:=P -> (
     d:=ambdim P_0_0;
     A:=submatrix'(id_(ZZ^d),{d-1},{});
     affineImage(A,P_0_0))

--Purpose: Evaluate a divisorial polytope at a specific weight
--Input: A divisorial polytope as ZeroCycle and a weight as List
--Output: A ZeroCycle
fhstar (ZeroCycle,List):=(Z,u) -> (
     A:=transpose(matrix({append(0*(toList (2..ambdim(Z_0_0))),1)}));
     f:=convexHull((transpose matrix {append(u,0)}),((-A)|A));
     g:= T -> (
	  {floor max flatten entries vertices affineImage(transpose A,intersection(T_0,f)),T_1});
     new ZeroCycle from apply(Z,g))
     
--Purpose: Create a tcode
--Input: The basis curve as a ProjectiveVariety, the divisorial polytope as ZeroCycle, and the evaluation base points as ZeroCycle
--Output: The generator Matrix of the resulting code
--Note: If the divisorial polytope isn't "globally generated" we will likely get some error message
tcode(ProjectiveVariety,ZeroCycle,ZeroCycle):=(Y,h,Z)->(
     F:=coefficientRing ring(Y);
     T:=torus(F,ambdim weightpoly h);
     f:=u->agcode(divisor(fhstar(h, u),Y),Z);
     g:=u->(f(u)*apply(T,t->(multipower(t, u))));
     W:=apply(latticePoints weightpoly h,v->flatten entries v);
     matrix apply(W,g)
     )
     
     
--Purpose: Create a toric code
--Input: A Polyhedron and the field we work over as Ring
--Output: The generator Matrix of the resulting code
toriccode(Polyhedron,Ring):= (P,F) -> (
	I:=latticePoints P;
	T:=torus(F,ambdim P);
	M:=apply(I, p -> (apply(T, t -> multipower(t, flatten entries p))));
	matrix(F,M))


--Purpose: Take powers in multi-index notation
--Input: A List of variable values and a List of exponents
--Output: Whatever Type the list elements were
multipower(List,List):=(L,M) -> (
	N:=for i to (#L-1) list (L_i)^(M_i);
	product N)

-- Some more helpful functions
torus= (F,n)-> (
     L:=fieldelements(F);
     mytuples(drop(L,1),n))



beginDocumentation()
document {
	Key => Points,
	"A Macaulay2 package for computing with toric codes",
        PARA{},
	}
end
