#include "Timer.h"
#include <stdio.h>

void TimerInit(HighPerformanceTimer* HPT)
{
	LARGE_INTEGER Frequency;
	int status = QueryPerformanceFrequency(&Frequency);
	if (!status) { printf("No performance counter\n"); exit(0); }
	HPT->CPS = Frequency.LowPart;
}

void ReStartTimer(HighPerformanceTimer* HPT)
{
	QueryPerformanceCounter(&(HPT->start));
}

void StopTimer(HighPerformanceTimer* HPT)
{
	QueryPerformanceCounter(&(HPT->finish));
}

double GetInterval(HighPerformanceTimer* HPT)
{
	return (((HPT->finish.HighPart - HPT->start.HighPart)*(double)UINT_MAX +
			 (HPT->finish.LowPart  - HPT->start.LowPart))/(double)HPT->CPS);
}
