/**********************************************************
 *  These timer routines are a conversion of Bryan Cooks' *
 *  simple High-Performance timer class from C++ to C.    *
 *  Special thanks to Bryan Cook for posting his routines.*
 **********************************************************/

#ifndef TIMER_H
#define TIMER_H

#include <limits.h>
#include <windows.h>

typedef struct
{
	LARGE_INTEGER start,finish;
	unsigned long CPS;
} HighPerformanceTimer;

void TimerInit(HighPerformanceTimer* HPT);
void ReStartTimer(HighPerformanceTimer* HPT);
void StopTimer(HighPerformanceTimer* HPT);
double GetInterval(HighPerformanceTimer* HPT);

#endif