
extern int g_nCamKeys;  /* number of camera keys */
extern int g_CamKeys[MAXKEYS];  /* list of camera keys */


extern double g_eyex;   /* camera center x */
extern double g_eyey;   /* camera center y */
extern double g_eyez;   /* camera center z */
extern double g_fovy;   /* field of view */

extern double g_rad;      /* distance from camera to head */
extern double g_phi;    /* horizontal angle*/
extern double g_theta;    /* vertical angle */

extern int g_camera;

int InitCamera();	//KLL
int UpdateCamera();
int ReadCameraKey(int f);
int WriteCameraKey(int f);
int CamLowKey(int f);
int LookCameraKey(int f);
int DeleteCameraKey(int f);
int ScaleCameraKeys(int nlf,int ff,int lf);
double CamLinterp(int f, int f0, int f1, double v0, double v1); 
int SaveCameraKeys(char filename[]);
int LoadCameraKeys(char filename[]);
int PrintCameraKeys();
void ResetCamera();

#define MAXCAMPM 4
//#define PI 3.141592

struct ckrec {    
	double eyex[MAXKEYS];
	double eyey[MAXKEYS];
	double eyez[MAXKEYS];
	double fovy[MAXKEYS];
} camkrec; 


