/* ==========================================================================
                               FILEIO.C
=============================================================================

    DESCRIPTION
	This module is responsible for reading the face data files.
	
	HISTORY
	1/01    steve dipaola  ported from sgi

    FUNCTION NAMES
    readpt					-- reads  input points file
    readt					-- reads input poly file

    C SPECIFICATIONS
    int readpt (ptsin, filename)
    int readt (filename)

============================================================================ */

#include <math.h>		/* C header for any math functions	     */
#include <stdio.h>		/* C header for standard I/O                 */
#include <string.h>		/* For String compare 			     */
#include <stdlib.h>
#ifndef _WIN32
#include <sys/types.h>
#include <sys/file.h>
#endif

#include "head.h"	   /* local header for the face		             */

/* 
 * from /usr/include/sys/types.h
 * Just in case TRUE and FALSE are not defined
 */

#ifndef TRUE
#define TRUE    1
#endif

#ifndef FALSE
#define FALSE   0
#endif

#define MAX_PT_POLY 3000
#define MAX_LINE 128



/*		*** readpt ***		*/
/*	- read in pt file		*/
int readpt( float ptsin[MAX_PT_POLY][3], char *filename )

	{
	  int n;
	  FILE *ifp, *fopen();
          char line[80],s[20];	
	  if ((ifp = fopen(filename,"r"))==NULL) {
		fprintf(stderr,"Can't open %s\n",filename);
		exit(-1) ;
	  }
	  fgets(line,80,ifp);
	  while (fscanf(ifp,"%s",s)==1){
	     if (strcmp(s,"%") != 0){
		n = atoi(s);
		fscanf(ifp,"%f %f %f",&ptsin[n][0],&ptsin[n][1],&ptsin[n][2]);
	   } else fgets(line,80,ifp);
         }
	 fclose(ifp);
	 return(n);
	}

char *fgets();


/*		*** readt ***			*/
/*	- reads in topology file		*/
/* reads in float, converts to int.int 		*/
int readt(char *filename)
	{
	  int i, j;
	  char s[80],line[MAX_LINE];
	  float tmp[3];
	  FILE *fp, *fopen();
	  if ((fp = fopen(filename,"r"))==NULL) {
		fprintf(stderr,"Can't open %s\n",filename);
		exit(-1) ;
	  }
	  fgets(line,80,fp); /* skip first line */
	  g_pc[0]=0;
	  i=1;
	  fgets(line,80,fp);
	  while (fscanf(fp,"%s",s)==1){
	     if (strcmp(s,"%") != 0){ /* skip comments */
		g_pc[i] = atoi(s);  /* material number for color */
		fscanf(fp,"%f %f %f",&tmp[0],&tmp[1],&tmp[2]);
		for (j=0; j<3; j++) {/* read poly(pg) & poly norm index(pgni) */
		   g_pg[i][j]=tmp[j];
		   g_pgni[i][j]=(int)(((tmp[j]-(float)g_pg[i][j])+.05)*10.);
		}
/*
if (debug) fprintf(stderr,"pg# %d, pg1 %d, pgni1 %d\n",i,g_pg[i][0],g_pgni[i][0]);
*/
		i++;
	   } else fgets(line,80,fp);
         }
	  fclose(fp);
	  return(i-1);
	}



