/* ==========================================================================
                            HEAD.H
=============================================================================

    DESCRIPTION
    Main header file used by all routines. Contain many global data structures.
	Yes there are way to many globals and no mallocs!

    HISTORY
	1/01   steve dipaola    ported from SGI 


============================================================================ */

#include "radians.h"
#include "Timer.h"  // added by GCK
#include <stdio.h>
#define MAX_PT_POLY 3000

// main.c
extern int verbose;
void InitParams() ;
void faceinit ( void );
void draw_mode_select(int value);
void goose();

// display.c
void paint_polygons	( int type ) ;
void comnor();
void vnorm ( float smooth );

// fileio.c
int readpt( float ptsin[MAX_PT_POLY][3], char *filename );
int readt(char *filename);

// keys.c
int DrawFrame(float f);   //  changed by GCK 3/7/01, for timer
void PrintKeys(int f);
int SetUpKeys();
void InitKeys();
void linterp(int f,int f0,int f1,float lv0[],float lv1[],float rv0[],float rv1[]);
int ReadKey(int f);
int ReadFrame(int f);
int WriteKey(int f);
int DeleteKey(int f);
void WriteKeyData(FILE *, int);	//aadesche change from char * to FILE *
int LookKey(int f);
int LowKey(int f);
int NextHigherKey(int f);
int NextLowerKey(int f);
int GetKey(int k,float keypml[],float keypmr[]);
void Ferr(char type,int num,char *fname);
int ScaleKeys(int nlf,int ff,int lf);
int DumpKeyFile();
int WriteParam(int lf,int hf,int pnum,float lpval,float rpval);
int InterpParam(int lf,int hf,int pnum);
int CreateLips(char file[]);
int AddLipParams(int f);
int ConvertKeys80();
int ConvertKeys110();
int GetRegionPm(char rname[]);
int ReadLibrary(char *pffile,int frtf_on);
int WriteLibrary(char * pffile);

// params.c
void UpdateObject () ;

void sub58( int off );
   void sub31( int off );
   void sub32( int off );
   void sub33( int off );
   void sub14( int off );
   void sub12( int off );
   void sub15( int off );
   void sub35( int off );
   void sub36( int off );
   void sub4( int off );
   void sub34( int off );  
   void eyebrows( int off );
   void eyes( int off ); 
   void sub26( int off );
   void sub27( int off );
   void sub10( int off );
   void sub11( int off );
   void sub13( int off ); 
   void sub53( int off );
   void sub16( int off );
   void sub17( int off );
   void sub19( int off );
   void sub20( int off );
   void sub62( int off );
   void sub63( int off );
   void sub64( int off );
   void sub65( int off );
   void sub66( int off );
   void sub67( int off );
   void sub68( int off );
   void sub69( int off );
   void sub70( int off );
   void sub71( int off );
   void sub72( int off );
   void sub73( int off );
   void sub74( int off );
   void sub75( int off );
   void sub76( int off );
   void sub77( int off );
   void sub78( int off );
   void sub79( int off );
   void sub54( int off );
   void sub55( int off );
   void sub56( int off );
   void sub57( int off );
   void sub37( int off );
    void sub40( int off );
    void teeth( int off );
    void jrot(int i,float sa,float ca, int off);
    void jyrot(int i,float sa,float ca, int off);


#define MAXKEYS	500  
#define MAX_LINE 128
#define MAXPM 163
#define	BOTH 0
#define	LEFT 1
#define	RIGHT 2

#define TRUE 1
#define FALSE 0
	
#define HUMAN 0			/* facetype used for eye correction and colors */
#define NOTHUMAN 1

int g_keys[MAXKEYS];	/* list of key frames */
int g_nkeys;		/* number of key frames */
int g_curframe;   /* current frame number */
int g_anim;

int g_lipsync,g_facetype; /* lipsync is on/off, facetype is human/nonhuman */
int warp; /* futre wapr param */

float	g_pt[MAX_PT_POLY][3];	/* active points */
float 	g_inpts[MAX_PT_POLY][3]; /* input points */
float	g_interp[MAX_PT_POLY][3]; /* second set of points to interpolate */
//yw changed! start
float tex[MAX_PT_POLY][3][3];	/* tex coords*/
//yw changed! end

int	DRAWLOC;	/* mps location of drawing routine */
int g_lbinc;
#define SYMMAX	29	/* # of points on symetry line */
extern int g_sym[]; 		/* pts on symetry line (x=0) */
float	g_pgn[MAX_PT_POLY][3];	/* polygon normals	*/
float	g_vn[MAX_PT_POLY][3];    /* vertex normals	*/
int	g_nn[MAX_PT_POLY];	/* vertex normal indexing  */
int	g_pg[MAX_PT_POLY][3];	/* polygon array	*/
int	g_pgni[MAX_PT_POLY][3];	/* polygon normal indexing */
int	g_np;		/* number of points	*/
int	g_ng;		/* number of polygons	*/
int	g_pc[MAX_PT_POLY];	/* polygon color	*/


/* GCK 3.09.01 -------->   */
#define LINEAR 0
#define QUADRATIC 1
#define NOISY 2
int g_interpMode; /*  type of interpolation curve  GCK 3.09.01 */
int g_playFrom;  /* play animation starting from */
int g_playTo;    /* play animation to... */
int g_width;     /* width of screen - used for screenshots */
int g_height;    /* height of screen - used for screenshots */
/*  ------> GCK 3.09.01 */

HighPerformanceTimer* animTimer;
float anim_frame;

double pixdx; // GCK 3/11
double pixdy; // GCK 3/11

char* g_sndFileName;

float ipmr[MAXPM],ipml[MAXPM],*ipm; /* input parameters */
float bpmr[MAXPM],bpml[MAXPM],*bpm; /* before parameters */
float wpmr[MAXPM],wpml[MAXPM],*wpm; /* writen out before parameters */
float cpmr[MAXPM],cpml[MAXPM],*cpm; /* current parameters */



