/*% cc % -a -g
 *
*/

#include <stdio.h>
#include "head.h"

int frtf[40];    /* facial region track facility tmp array */

/*  ReadLibrary  - read in entry (pm file)  and apply to current frame */
int ReadLibrary(char *pffile,int frtf_on)
{
char pletter;
int  i=0, match=1, pnum;
float pval;
FILE *pfp ,*fopen();
   if ((pfp = fopen(pffile,"r"))==NULL) {
    fprintf(stderr,"Can not read file \"%s\".\n",pffile);
    return(FALSE);
   }
   match=1;
    while (fscanf(pfp,"%c %d %f\n", &pletter,&pnum,&pval)>0) {
       if (frtf_on) {
       match=0;
       for(i=0;i<40;i++) if (pnum==frtf[i]) match=1;
       }
       if (match){
          if (pletter=='r') cpmr[pnum]=pval;
          else if (pletter=='l') cpml[pnum]=pval;
          else if (pletter=='p') { cpml[pnum]=pval; cpmr[pnum]=pval; }
          else { fprintf(stderr,"error pletter=%c\n",pletter); return(FALSE); }
       }
    }
      memmove(bpml,cpml,sizeof(bpml));
      memmove(bpmr,cpmr,sizeof(bpmr));
      memmove(wpml,cpml,sizeof(wpml));
      memmove(wpmr,cpmr,sizeof(wpmr));
    fclose(pfp);
    return(TRUE);
}

/* write out entry to library */
int WriteLibrary(char * pffile)
{
char pletter;
int  i, pnum;
FILE *pfp ,*fopen();
   if ((pfp = fopen(pffile,"w"))==NULL) {
    fprintf(stderr,"Can not create file \"%s\".\n",pffile);
    return(FALSE);
   }
   for (i=1; i<MAXPM; i++) {
      if (cpml[i]==cpmr[i])
         fprintf(pfp,"p %d %g\n",i,cpmr[i]);
       else {
         fprintf(pfp,"r %d %g\n",i,cpmr[i]);
         fprintf(pfp,"l %d %g\n",i,cpml[i]);
      }
    }
      memmove(wpml,cpml,sizeof(wpml));
      memmove(wpmr,cpmr,sizeof(wpmr));
    fprintf(stderr,"Library entry \"%s\" saved.\n",pffile);
    fclose(pfp);
    return(TRUE);
}

