/* ==========================================================================
                            MOUTH.C
=============================================================================

    DESCRIPTION
    This module has mouth based face parameter routines. Works with params.c which has
	the main face param calling routine as well as other face params and eye.c which
	has the eye parameter routines. See the InitParams for an explanation of the specific
	mouth params. There alot of funky magic code in here!

    HISTORY
	1/01   steve dipaola    ported from SGI


    FUNCTION NAMES


    C SPECIFICATIONS

============================================================================ */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "head.h"


/*              +++++ jaw routines +++++		*/
void teeth(int off)

{
int i;
if (off) { /* upper teeth */ 
   for (i=1301; i<=1380; i++) {
      g_pt[i][0]+=cpm[47]; 
      g_pt[i][1]+=cpm[48];
      g_pt[i][2]+=cpm[49];
      g_pt[i][0]*=cpm[100]; 
	}
}
else { /* bottom teeth */
   for (i=1401; i<=1496; i++) {
      g_pt[i][0]+=cpm[47];
      g_pt[i][1]+=cpm[48];
      g_pt[i][2]+=cpm[49];
      g_pt[i][0]*=cpm[100]; 
   }
} 
}
   
/*	jaw rotation		*/
void sub4(int off)

{
   int i;
float sa,ca,cpm4;
//double dtr = DEG_RAD;
cpm4 = -cpm[4];
if (cpm[4]!=ipm[4]) {

   	sa = sin(DEG_RAD * cpm4);
	ca = cos(DEG_RAD * cpm4);
   	for (i=14+off; i<=43+off; i++)
   		jrot(i,sa,ca,off);
   	i=294+off; jrot(i,sa,ca,off);
   	for (i=49+off; i<=58+off; i+=3)
   		jrot(i,sa,ca,off);
 /* bottom teeth */
 if (!off)
   	for (i=1401; i<=1496; i++)
   		jrot(i,sa,ca,off);

   	sa=sin(DEG_RAD * cpm4 *.98);
	ca=cos(DEG_RAD * cpm4 * .98);
   	for (i=50+off; i<=59+off; i+=3)
   		jrot(i,sa,ca,off);

   	sa=sin(DEG_RAD * cpm4 *.75);
	ca=cos(DEG_RAD * cpm4 * .75);
   	for (i=11+off; i<=13+off; i++)
   		jyrot(i,sa,ca,off);
   	for (i=51+off; i<=60+off; i+=3)
   		jrot(i,sa,ca,off);

   	sa =sin(DEG_RAD * cpm4 * .5);
	ca =cos(DEG_RAD * cpm4 * .5);
   	for (i=6+off; i<=10+off; i++)
   		jyrot(i,sa,ca,off);

   	sa =sin(DEG_RAD * cpm4 * .35);
	ca =cos(DEG_RAD * cpm4 * .35);
   	for (i=44+off; i<=48+off; i++)
   		jrot(i,sa,ca,off);
   	jrot(70+off,sa,ca,off);
   	jrot(287+off,sa,ca,off);
  }
}

   	/*	jaw X scale		*/
   
void sub19(int off)

{
   int i;
  if (cpm[19]!=ipm[19]) {
      for ( i=11+off; i<=40+off; i++ )
   	 g_pt[i][0]=g_pt[i][0]*(1.0+(cpm[19]-1.0)*(g_pt[i][2]/g_pt[23+off][2]));
    i=294+off; g_pt[i][0]=g_pt[i][0]*(1.0+(cpm[19]-1.0)*(g_pt[i][2]/g_pt[23+off][2]));
    }
 } 

/*		*** jrot ***		*/
/*	- jaw rotation in y and z	*/

void jrot(int i,float sa,float ca, int off)
{
   float y,z; 
   y=g_pt[i][1]-g_pt[107][1];
   z=g_pt[i][2]-g_pt[107][2];
   g_pt[i][1]=y*ca-z*sa+g_pt[107][1];
   g_pt[i][2]=z*ca+y*sa+g_pt[107][2];
}

/*		*** jyrot ***		*/
/*	- jaw rotation in y		*/

void jyrot(int i,float sa,float ca, int off)
{
   float y,z; 
   y=g_pt[i][1]-g_pt[107][1];
   z=g_pt[i][2]-g_pt[107][2];
   g_pt[i][1]=y*ca-z*sa+g_pt[107][1];
}

/*		+++++ mouth +++++		*/

   	/*	Z offset for mouth	*/
   
void sub14(int off)

{
   int i;
  if (cpm[14]!=ipm[14]) {
   g_pt[44+off][2]=g_pt[44+off][2]+.3*cpm[14];
   g_pt[70+off][2]=g_pt[70+off][2]+.3*cpm[14];
   g_pt[287+off][2]=g_pt[287+off][2]+.3*cpm[14];
   for(i=49+off; i<=67+off; i+=3) {
      g_pt[i][2]=g_pt[i][2]+cpm[14];
      g_pt[i+1][2]=g_pt[i+1][2]+.8*cpm[14];
      g_pt[i+2][2]=g_pt[i+2][2]+.6*cpm[14];
   }
  }
}
   
   	/*	lip thickness  y scale		*/
   
void sub15(int off)

{
   int i,j;
  if (cpm[15]!=ipm[15]) {
   if (off)  /* top */
      for (j=0; j<=300; j+=300) {
   	for (i=64+j; i<=66+j; i++)
   		g_pt[i][1]=g_pt[i][1]+.5*cpm[15];
   	for (i=67+j; i<=69+j; i++)
   		g_pt[i][1]=g_pt[i][1]+cpm[15];
   	for (i=71+j; i<=73+j; i++)
   		g_pt[i][1]=g_pt[i][1]+.4*cpm[15];
		/* out in z  for curvature */
	for (i=64+j; i<=66+j; i++)
   		g_pt[i][2]=g_pt[i][2]-.3*cpm[15];
    }
    else  /* bot */
      for (j=0; j<=300; j+=300) {
   	for (i=49+j; i<=51+j; i++)
   		g_pt[i][1]=g_pt[i][1]-cpm[15];
   	for (i=52+j; i<=54+j; i++)
   		g_pt[i][1]=g_pt[i][1]-.77*cpm[15];
   	for (i=55+j; i<=57+j; i++)
   		g_pt[i][1]=g_pt[i][1]-.33*cpm[15];
   	for (i=41+j; i<=43+j; i++)
   		g_pt[i][1]=g_pt[i][1]-.4*cpm[15];
		/* out in z  for curvature */
   	for (i=52+j; i<=57+j; i++)
   		g_pt[i][2]=g_pt[i][2]-.3*cpm[15];
	}
   
  }
}

   	/*	mouth X scale		*/
   
void sub12(int off)

{
   int i, toff=0;
   float taper;
  if (cpm[12]!=ipm[12]) {
   	for (i=41+off; i<=43+off; i++)
   		g_pt[i][0]=g_pt[i][0]*cpm[12];
   	for (i=49+off; i<=73+off; i++)
   		g_pt[i][0]=g_pt[i][0]*cpm[12];
if (off) toff=40;	/* upper teeth */
   	for (i=1301+toff; i<=1340+toff; i++)
   		g_pt[i][0]=g_pt[i][0]*cpm[12];
if (off) toff=48; 	/* lower teeth */
   	for (i=1401+toff; i<=1448+toff; i++)
   		g_pt[i][0]=g_pt[i][0]*cpm[12];
   	i=287+off;
   		g_pt[i][0]=g_pt[i][0]*cpm[12];

   	
	i=44; taper=.5; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=45; taper=.4; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=46; taper=.4; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=47; taper=.2; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=36; taper=.3; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=37; taper=.3; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=38; taper=.2; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=96; taper=.3; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=97; taper=.3; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=102; taper=.2; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
	i=25; taper=.2; g_pt[i+off][0]=g_pt[i+off][0]*(1.0+taper*(cpm[12]-1.0));
  }
}

/*		+++++ lip routines +++++		*/
   
   
   	/*	adjust corner of mouth		*/
	/* move in x is negative left side pass */
	/* NOT USED
void sub16(int off)

{
   int i,j,x=1;
  if (cpm[16]!=ipm[16]) {
   	if (off) x = -1;
   
   	i=70+off;
   	g_pt[i][0]=g_pt[i][0]+x*cpm[16];
   	for (j=1; j<3; j++)
   		g_pt[i][j]=g_pt[i][j]+cpm[j+16];
   	i=287+off;
   	g_pt[i][0]=g_pt[i][0]+x*cpm[16];
   	for (j=1; j<3; j++)
   		g_pt[i][j]=g_pt[i][j]+cpm[j+16];
   	i=44+off;
   	g_pt[i][0]=g_pt[i][0]+x*cpm[16];
   	for (j=1; j<3; j++)
   		g_pt[i][j]=g_pt[i][j]+cpm[j+16];
  }
} 
  */

   	/*	lower lip "f" tuck	*/
   
void sub21(int off)

{
   int i;
  if (cpm[21]!=ipm[21]) {
   	for (i=49+off; i<=58+off; i+=3)
   		{
   		 g_pt[i][2]=g_pt[i][2]+cpm[21];
   		 g_pt[i+1][2]=g_pt[i+1][2]+.8*cpm[21];
   		 g_pt[i+2][2]=g_pt[i+2][2]+.6*cpm[21];
   		 g_pt[i][1]=g_pt[i][1]-cpm[21];
   		 g_pt[i+1][1]=g_pt[i+1][1]-.925*cpm[21];
   		 g_pt[i+2][1]=g_pt[i+2][1]-.8*cpm[21];
   		}
  }
}
   
   	/*	raise upper lip		*/
   
void sub22(int off)

{
   int i;
  if (cpm[22]!=ipm[22]) {
   	for (i=61+off; i<=67+off; i+=3)
   		{
   		 g_pt[i][1]=g_pt[i][1]+cpm[22];
   		 g_pt[i+1][1]=g_pt[i+1][1]+.7*cpm[22];
   		 g_pt[i+2][1]=g_pt[i+2][1]+.4*cpm[22];
   
   		}
 }
}


/* top lip move y */

void sub62(int off)

{
  if (cpm[62]!=ipm[62]) {
g_pt[61+off][1] = g_pt[61+off][1] +( .7 * cpm[62]);
g_pt[64+off][1] = g_pt[64+off][1] +( .7 * cpm[62]);
g_pt[67+off][1] = g_pt[67+off][1] +( .8 * cpm[62]);
g_pt[71+off][1] = g_pt[71+off][1] +( .5 * cpm[62]);
g_pt[62+off][1] = g_pt[62+off][1] +( .7 * cpm[62]);
g_pt[63+off][1] = g_pt[63+off][1] +( .4 * cpm[62]);
g_pt[65+off][1] = g_pt[65+off][1] +( .7 * cpm[62]);
g_pt[66+off][1] = g_pt[66+off][1] +( .4 * cpm[62]);
g_pt[68+off][1] = g_pt[68+off][1] +( .7 * cpm[62]);
g_pt[69+off][1] = g_pt[69+off][1] +( .4 * cpm[62]);
g_pt[72+off][1] = g_pt[72+off][1] +( .35 * cpm[62]);
g_pt[73+off][1] = g_pt[73+off][1] +( .2 * cpm[62]);
}
}

 /* lip corners move x,y,z */

void sub63(int off)

{
  if (cpm[63]!=ipm[63]) {
g_pt[287+off][0] = g_pt[287+off][0] +( cpm[63]);
g_pt[70+off][0] = g_pt[70+off][0] +( .9 * cpm[63]);
g_pt[44+off][0] = g_pt[44+off][0] +( .8 * cpm[63]);
}
}

void sub64(int off)

{
  if (cpm[64]!=ipm[64]) {
g_pt[287+off][1] = g_pt[287+off][1] +( cpm[64]);
g_pt[70+off][1] = g_pt[70+off][1] +( .9 * cpm[64]);
g_pt[44+off][1] = g_pt[44+off][1] +( .8 * cpm[64]);
}
}

void sub65(int off)

{
  if (cpm[65]!=ipm[65]) {
g_pt[287+off][2] = g_pt[287+off][2] +( cpm[65]);
g_pt[70+off][2] = g_pt[70+off][2] +( .9 * cpm[65]);
g_pt[44+off][2] = g_pt[44+off][2] +( .8 * cpm[65]);
}
}
 /* corners */

/* middle top lip  move in x and y */
void sub16(int off)

{
  if (cpm[16]!=ipm[16]) {
g_pt[61][0] = g_pt[61][0] +( cpm[16]);
g_pt[64][0] = g_pt[64][0] +( .9 * cpm[16]);
g_pt[67][0] = g_pt[67][0] +( .8 * cpm[16]);
}
}

void sub17(int off)

{
  if (cpm[17]!=ipm[17]) {
g_pt[61][1] = g_pt[61][1] +( cpm[17]);
g_pt[64][1] = g_pt[64][1] +( .9 * cpm[17]);
g_pt[67][1] = g_pt[67][1] +( .8 * cpm[17]);
}
}
/* middle top lip  move in x and y */

/* inner top lip  move in x and y */
void sub66(int off)

{
  if (cpm[66]!=ipm[66]) {
g_pt[62+off][0] = g_pt[62+off][0] +( cpm[66]);
g_pt[65+off][0] = g_pt[65+off][0] +( .9 * cpm[66]);
g_pt[68+off][0] = g_pt[68+off][0] +( .8 * cpm[66]);
}
}

void sub67(int off)

{
  if (cpm[67]!=ipm[67]) {
g_pt[62+off][1] = g_pt[62+off][1] +( cpm[67]);
g_pt[65+off][1] = g_pt[65+off][1] +( .9 * cpm[67]);
g_pt[68+off][1] = g_pt[68+off][1] +( .8 * cpm[67]);
}
}

void sub68(int off)

{
  if (cpm[68]!=ipm[68]) {
g_pt[62+off][2] = g_pt[62+off][2] +( cpm[68]);
g_pt[65+off][2] = g_pt[65+off][2] +( .9 * cpm[68]);
g_pt[68+off][2] = g_pt[68+off][2] +( .8 * cpm[68]);
}
}
 /* inner top lips */

/* outter top lips move in x and y */
void sub69(int off)

{
  if (cpm[63]!=ipm[63]) {
g_pt[63+off][0] = g_pt[63+off][0] +( cpm[69]);
g_pt[66+off][0] = g_pt[66+off][0] +( .9 * cpm[69]);
g_pt[69+off][0] = g_pt[69+off][0] +( .8 * cpm[69]);
}
}

void sub70(int off)

{
  if (cpm[70]!=ipm[70]) {
g_pt[63+off][1] = g_pt[63+off][1] +( cpm[70]);
g_pt[66+off][1] = g_pt[66+off][1] +( .9 * cpm[70]);
g_pt[69+off][1] = g_pt[69+off][1] +( .8 * cpm[70]);
}
}

void sub71(int off)

{
  if (cpm[71]!=ipm[71]) {
g_pt[63+off][2] = g_pt[63+off][2] +( cpm[71]);
g_pt[66+off][2] = g_pt[66+off][2] +( .9 * cpm[71]);
g_pt[69+off][2] = g_pt[69+off][2] +( .8 * cpm[71]);
}
}
 /* outter top lips */

 /* top "o" shape lips */
void sub72(int off)

{
  if (cpm[72]!=ipm[72]) {
g_pt[61+off][1] = g_pt[61+off][1] +( 1.0 * cpm[72]);
g_pt[64+off][1] = g_pt[64+off][1] +( 1.0 * cpm[72]);
g_pt[67+off][1] = g_pt[67+off][1] +( 1.0 * cpm[72]);
g_pt[62+off][1] = g_pt[62+off][1] +( .9 * cpm[72]);
g_pt[65+off][1] = g_pt[65+off][1] +( .9 * cpm[72]);
g_pt[68+off][1] = g_pt[68+off][1] +( .9 * cpm[72]);
g_pt[63+off][1] = g_pt[63+off][1] +( .4 * cpm[72]);
g_pt[66+off][1] = g_pt[66+off][1] +( .4 * cpm[72]);
g_pt[69+off][1] = g_pt[69+off][1] +( .4 * cpm[72]);
g_pt[71+off][1] = g_pt[71+off][1] +( .65 * cpm[72]);
g_pt[72+off][1] = g_pt[72+off][1] +( .55 * cpm[72]);
g_pt[73+off][1] = g_pt[73+off][1] +( .2 * cpm[72]);
}
}

 /* bot "o" shape lips */
void sub73(int off)

{
  if (cpm[73]!=ipm[73]) {
g_pt[58+off][1] = g_pt[58+off][1] +( 1.0 * cpm[73]);
g_pt[55+off][1] = g_pt[55+off][1] +( 1.0 * cpm[73]);
g_pt[52+off][1] = g_pt[52+off][1] +( 1.0 * cpm[73]);
g_pt[49+off][1] = g_pt[49+off][1] +( 1.0 * cpm[73]);
g_pt[59+off][1] = g_pt[59+off][1] +( .9 * cpm[73]);
g_pt[56+off][1] = g_pt[56+off][1] +( .9 * cpm[73]);
g_pt[53+off][1] = g_pt[53+off][1] +( .9 * cpm[73]);
g_pt[50+off][1] = g_pt[50+off][1] +( .9 * cpm[73]);
g_pt[60+off][1] = g_pt[60+off][1] +( .4 * cpm[73]);
g_pt[57+off][1] = g_pt[57+off][1] +( .4 * cpm[73]);
g_pt[54+off][1] = g_pt[54+off][1] +( .4 * cpm[73]);
g_pt[51+off][1] = g_pt[51+off][1] +( .4 * cpm[73]);
g_pt[41+off][1] = g_pt[41+off][1] +( .65 * cpm[73]);
g_pt[42+off][1] = g_pt[42+off][1] +( .55 * cpm[73]);
g_pt[43+off][1] = g_pt[43+off][1] +( .2 * cpm[73]);
}
}
 /* olips */

 /* top lip move z */
void sub74(int off)

{
 /* middle */
  if (cpm[74]!=ipm[74]) {
g_pt[61+off][2] = g_pt[61+off][2] +( .8 * cpm[74]);
g_pt[64+off][2] = g_pt[64+off][2] +( cpm[74]);
g_pt[67+off][2] = g_pt[67+off][2] +( .8 * cpm[74]);
g_pt[71+off][2] = g_pt[71+off][2] +( .5 * cpm[74]);
 /* left,right */
g_pt[62+off][2] = g_pt[62+off][2] +( (.7 * .8) * cpm[74]);
g_pt[63+off][2] = g_pt[63+off][2] +( (.4 * .8) * cpm[74]);
g_pt[65+off][2] = g_pt[65+off][2] +( .7 * cpm[74]);
g_pt[66+off][2] = g_pt[66+off][2] +( .4 * cpm[74]);
g_pt[68+off][2] = g_pt[68+off][2] +( (.7 * .8) * cpm[74]);
g_pt[69+off][2] = g_pt[69+off][2] +( (.4 * .8) * cpm[74]);
g_pt[72+off][2] = g_pt[72+off][2] +( (.7 * .5) * cpm[74]);
g_pt[73+off][2] = g_pt[73+off][2] +( (.4 * .5) * cpm[74]);
}
}
 /* top lip move z */

 /* bot lip move z */
void sub75(int off)

{
  if (cpm[75]!=ipm[75]) {
g_pt[58+off][2] = g_pt[58+off][2] +( .8 * cpm[75]);
g_pt[55+off][2] = g_pt[55+off][2] +( cpm[75]);
g_pt[52+off][2] = g_pt[52+off][2] +( cpm[75]);
g_pt[49+off][2] = g_pt[49+off][2] +( .8 * cpm[75]);
g_pt[41+off][2] = g_pt[41+off][2] +( .5 * cpm[75]);
 /* bot left */
g_pt[59+off][2] = g_pt[59+off][2] +( (.7 * .8) * cpm[75]);
g_pt[60+off][2] = g_pt[60+off][2] +( (.4 * .8) * cpm[75]);
g_pt[56+off][2] = g_pt[56+off][2] +( .7 * cpm[75]);
g_pt[57+off][2] = g_pt[57+off][2] +( .4 * cpm[75]);
g_pt[53+off][2] = g_pt[53+off][2] +( .7 * cpm[75]);
g_pt[54+off][2] = g_pt[54+off][2] +( .4 * cpm[75]);
g_pt[50+off][2] = g_pt[50+off][2] +( (.7 * .8) * cpm[75]);
g_pt[51+off][2] = g_pt[51+off][2] +( (.4 * .8) * cpm[75]);
g_pt[42+off][2] = g_pt[42+off][2] +( (.7 * .5) * cpm[75]);
g_pt[43+off][2] = g_pt[43+off][2] +( (.4 * .5) * cpm[75]);
}
}
 /* bot lip move z */

 /* middle bot lip move y */
void sub76(int off)

{
  if (cpm[76]!=ipm[76]) {
g_pt[58+off][1] = g_pt[58+off][1] +( cpm[76]);
g_pt[55+off][1] = g_pt[55+off][1] +( cpm[76]);
g_pt[52+off][1] = g_pt[52+off][1] +( cpm[76]);
g_pt[49+off][1] = g_pt[49+off][1] +( cpm[76]);
g_pt[41+off][1] = g_pt[41+off][1] +( .5 * cpm[76]);
}
}

 /* inner bot lip move y */
void sub77(int off)

{
  if (cpm[77]!=ipm[77]) {
g_pt[59+off][1] = g_pt[59+off][1] +( cpm[77]);
g_pt[56+off][1] = g_pt[56+off][1] +( cpm[77]);
g_pt[53+off][1] = g_pt[53+off][1] +( cpm[77]);
g_pt[50+off][1] = g_pt[50+off][1] +( cpm[77]);
g_pt[42+off][1] = g_pt[42+off][1] +( .5 * cpm[77]);
}
}
 /* outter bot lip move y */
void sub78(int off)

{
  if (cpm[78]!=ipm[78]) {
g_pt[60+off][1] = g_pt[60+off][1] +( cpm[78]);
g_pt[57+off][1] = g_pt[57+off][1] +( cpm[78]);
g_pt[54+off][1] = g_pt[54+off][1] +( cpm[78]);
g_pt[51+off][1] = g_pt[51+off][1] +( cpm[78]);
g_pt[43+off][1] = g_pt[43+off][1] +( .5 * cpm[78]);
}
}

 /* smile */
void sub79(int off)

{
  if (cpm[79]!=ipm[79]) {
g_pt[287+off][1] = g_pt[287+off][1] +( .5 * cpm[79]);
g_pt[70+off][1] = g_pt[70+off][1] +( .5 * cpm[79]);
g_pt[44+off][1] = g_pt[44+off][1] +( .5 * cpm[79]);
g_pt[45+off][1] = g_pt[45+off][1] +( .4 * cpm[79]);
g_pt[46+off][1] = g_pt[46+off][1] +( .3 * cpm[79]);
g_pt[47+off][1] = g_pt[47+off][1] +( .2 * cpm[79]);
g_pt[69+off][1] = g_pt[69+off][1] +( .35 * cpm[79]);
}
}
/*
void sub79(int off)

{
g_pt[287+off][0] = g_pt[287+off][0] +( .4 * cpm[79]);
g_pt[287+off][2] = g_pt[287+off][2] +( .4 * cpm[79]);
g_pt[70+off][0] = g_pt[70+off][0] +( .5 * cpm[79]);
g_pt[70+off][2] = g_pt[70+off][2] +( .5 * cpm[79]);
g_pt[44+off][0] = g_pt[44+off][0] +( .8 * cpm[79]);
g_pt[44+off][2] = g_pt[44+off][2] +( .8 * cpm[79]);
g_pt[45+off][0] = g_pt[45+off][0] +( 1. * cpm[79]);
g_pt[45+off][2] = g_pt[45+off][2] +( 1. * cpm[79]);
g_pt[46+off][0] = g_pt[46+off][0] +( .7 * cpm[79]);
g_pt[46+off][2] = g_pt[46+off][2] +( .7 * cpm[79]);
g_pt[47+off][0] = g_pt[47+off][0] +( .2 * cpm[79]);
g_pt[47+off][2] = g_pt[47+off][2] +( .2 * cpm[79]);
g_pt[69+off][0] = g_pt[69+off][0] +( .35 * cpm[79]);
g_pt[69+off][2] = g_pt[69+off][2] +( .35 * cpm[79]);
}
*/
/* smile */
