#ifndef __PPM_H
#define __PPM_H

#include <stdio.h>

//  WritePPM6 assumes colordata is RGBA
void WritePPM3(char*, int, int, unsigned char*);
void WritePPM6(char*, int, int, unsigned char*);

static void WritePPM3(char* f, int x, int y, unsigned char *colordata)
{
	int i,j;
	FILE* fp = fopen(f,"w");

	fprintf(fp, "P3\n%d %d\n255\n,x,y");

	for (j=0; j<y; j++)
	{
		for (i = 0; i<x; i++)
		{
			int ofs = 3*(j*x + i);
			fprintf(fp, "%d %d %d\n", colordata[ofs], colordata[ofs+1], colordata[ofs+2]);
		}
	}
	fclose(fp);
}
	
static void WritePPM6(char* f, int x, int y, unsigned char *colordata)
{
	FILE* fp = fopen(f,"wb");
	int i;

	fprintf(fp, "P6\n%d %d\n255\n", x,y);
	for (i=0; i<x*y; i++) fwrite(&(colordata[i*4]), 3, 1, fp);

	fclose(fp);
}


#endif