/*
 *	RADIANS.H
 *
 *	Defines for pi, 2*pi, pi/2,
 *	and radians/degrees conversion factors.
 */

#ifndef RADIANSDEFS

#    define	RADIANSDEFS

		/* From Knuth: vol I */
#    define	TWOPI	6.2831853071795864769252867665590057683944
#    define	PI	3.1415926535897932384626433832795028841972
#    define	PIOVER2	1.5707963267948966192313216916397514420986

#    define	DEG_RAD	0.017453292519943295769236907684886
#    define	RAD_DEG	57.29577951308232087679815481410517

#    define	RADIANS(a)	((a)*DEG_RAD)
#    define	DEGREES(a)	((a)*RAD_DEG)

#endif RADIANSDEFS


